package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  BooleanType,
  RecoveryWindowInDaysType,
  SecretIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteSecretRequest(
    secretId: SecretIdType,
    recoveryWindowInDays: Optional[RecoveryWindowInDaysType] = Optional.Absent,
    forceDeleteWithoutRecovery: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest = {
    import DeleteSecretRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .optionallyWith(
        recoveryWindowInDays.map(value =>
          RecoveryWindowInDaysType.unwrap(value): java.lang.Long
        )
      )(_.recoveryWindowInDays)
      .optionallyWith(
        forceDeleteWithoutRecovery.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.forceDeleteWithoutRecovery)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.DeleteSecretRequest.ReadOnly =
    zio.aws.secretsmanager.model.DeleteSecretRequest.wrap(buildAwsValue())
}
object DeleteSecretRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.DeleteSecretRequest =
      zio.aws.secretsmanager.model.DeleteSecretRequest(
        secretId,
        recoveryWindowInDays.map(value => value),
        forceDeleteWithoutRecovery.map(value => value)
      )
    def secretId: SecretIdType
    def recoveryWindowInDays: Optional[RecoveryWindowInDaysType]
    def forceDeleteWithoutRecovery: Optional[BooleanType]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getRecoveryWindowInDays: ZIO[Any, AwsError, RecoveryWindowInDaysType] =
      AwsError.unwrapOptionField("recoveryWindowInDays", recoveryWindowInDays)
    def getForceDeleteWithoutRecovery: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "forceDeleteWithoutRecovery",
        forceDeleteWithoutRecovery
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest
  ) extends zio.aws.secretsmanager.model.DeleteSecretRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val recoveryWindowInDays: Optional[RecoveryWindowInDaysType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recoveryWindowInDays())
        .map(value =>
          zio.aws.secretsmanager.model.primitives
            .RecoveryWindowInDaysType(value)
        )
    override val forceDeleteWithoutRecovery: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forceDeleteWithoutRecovery())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.BooleanType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest
  ): zio.aws.secretsmanager.model.DeleteSecretRequest.ReadOnly = new Wrapper(
    impl
  )
}
