package zio.aws.secretsmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.secretsmanager.model.primitives.{
  SecretARNType,
  SecretVersionIdType,
  SecretBinaryType,
  SecretNameType,
  SecretVersionStageType,
  SecretStringType,
  CreatedDateType
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetSecretValueResponse(
    arn: Optional[SecretARNType] = Optional.Absent,
    name: Optional[SecretNameType] = Optional.Absent,
    versionId: Optional[SecretVersionIdType] = Optional.Absent,
    secretBinary: Optional[SecretBinaryType] = Optional.Absent,
    secretString: Optional[SecretStringType] = Optional.Absent,
    versionStages: Optional[Iterable[SecretVersionStageType]] = Optional.Absent,
    createdDate: Optional[CreatedDateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse = {
    import GetSecretValueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        versionId.map(value =>
          SecretVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .optionallyWith(
        secretBinary.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.secretBinary)
      .optionallyWith(
        secretString.map(value =>
          SecretStringType.unwrap(value): java.lang.String
        )
      )(_.secretString)
      .optionallyWith(
        versionStages.map(value =>
          value.map { item =>
            SecretVersionStageType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versionStages)
      .optionallyWith(
        createdDate.map(value => CreatedDateType.unwrap(value): Instant)
      )(_.createdDate)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.GetSecretValueResponse.ReadOnly =
    zio.aws.secretsmanager.model.GetSecretValueResponse.wrap(buildAwsValue())
}
object GetSecretValueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.GetSecretValueResponse =
      zio.aws.secretsmanager.model.GetSecretValueResponse(
        arn.map(value => value),
        name.map(value => value),
        versionId.map(value => value),
        secretBinary.map(value => value),
        secretString.map(value => value),
        versionStages.map(value => value),
        createdDate.map(value => value)
      )
    def arn: Optional[SecretARNType]
    def name: Optional[SecretNameType]
    def versionId: Optional[SecretVersionIdType]
    def secretBinary: Optional[SecretBinaryType]
    def secretString: Optional[SecretStringType]
    def versionStages: Optional[List[SecretVersionStageType]]
    def createdDate: Optional[CreatedDateType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
    def getVersionId: ZIO[Any, AwsError, SecretVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getSecretBinary: ZIO[Any, AwsError, SecretBinaryType] =
      AwsError.unwrapOptionField("secretBinary", secretBinary)
    def getSecretString: ZIO[Any, AwsError, SecretStringType] =
      AwsError.unwrapOptionField("secretString", secretString)
    def getVersionStages: ZIO[Any, AwsError, List[SecretVersionStageType]] =
      AwsError.unwrapOptionField("versionStages", versionStages)
    def getCreatedDate: ZIO[Any, AwsError, CreatedDateType] =
      AwsError.unwrapOptionField("createdDate", createdDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse
  ) extends zio.aws.secretsmanager.model.GetSecretValueResponse.ReadOnly {
    override val arn: Optional[SecretARNType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Optional[SecretNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
    override val versionId: Optional[SecretVersionIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionId())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.SecretVersionIdType(value)
        )
    override val secretBinary: Optional[SecretBinaryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretBinary())
        .map(value =>
          zio.aws.secretsmanager.model.primitives
            .SecretBinaryType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val secretString: Optional[SecretStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretString())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.SecretStringType(value)
        )
    override val versionStages: Optional[List[SecretVersionStageType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionStages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.secretsmanager.model.primitives.SecretVersionStageType(item)
          }.toList
        )
    override val createdDate: Optional[CreatedDateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.CreatedDateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse
  ): zio.aws.secretsmanager.model.GetSecretValueResponse.ReadOnly = new Wrapper(
    impl
  )
}
