package zio.aws.secretsmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.secretsmanager.model.primitives.{
  OwningServiceType,
  SecretARNType,
  LastAccessedDateType,
  SecretVersionIdType,
  RegionType,
  RotationEnabledType,
  NextRotationDateType,
  LastRotatedDateType,
  SecretNameType,
  TimestampType,
  KmsKeyIdType,
  DeletedDateType,
  SecretVersionStageType,
  RotationLambdaARNType,
  DescriptionType,
  LastChangedDateType
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SecretListEntry(
    arn: Optional[SecretARNType] = Optional.Absent,
    name: Optional[SecretNameType] = Optional.Absent,
    description: Optional[DescriptionType] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyIdType] = Optional.Absent,
    rotationEnabled: Optional[RotationEnabledType] = Optional.Absent,
    rotationLambdaARN: Optional[RotationLambdaARNType] = Optional.Absent,
    rotationRules: Optional[zio.aws.secretsmanager.model.RotationRulesType] =
      Optional.Absent,
    lastRotatedDate: Optional[LastRotatedDateType] = Optional.Absent,
    lastChangedDate: Optional[LastChangedDateType] = Optional.Absent,
    lastAccessedDate: Optional[LastAccessedDateType] = Optional.Absent,
    deletedDate: Optional[DeletedDateType] = Optional.Absent,
    nextRotationDate: Optional[NextRotationDateType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.secretsmanager.model.Tag]] =
      Optional.Absent,
    secretVersionsToStages: Optional[
      Map[SecretVersionIdType, Iterable[SecretVersionStageType]]
    ] = Optional.Absent,
    owningService: Optional[OwningServiceType] = Optional.Absent,
    createdDate: Optional[TimestampType] = Optional.Absent,
    primaryRegion: Optional[RegionType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.SecretListEntry = {
    import SecretListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.SecretListEntry
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyIdType.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        rotationEnabled.map(value =>
          RotationEnabledType.unwrap(value): java.lang.Boolean
        )
      )(_.rotationEnabled)
      .optionallyWith(
        rotationLambdaARN.map(value =>
          RotationLambdaARNType.unwrap(value): java.lang.String
        )
      )(_.rotationLambdaARN)
      .optionallyWith(rotationRules.map(value => value.buildAwsValue()))(
        _.rotationRules
      )
      .optionallyWith(
        lastRotatedDate.map(value => LastRotatedDateType.unwrap(value): Instant)
      )(_.lastRotatedDate)
      .optionallyWith(
        lastChangedDate.map(value => LastChangedDateType.unwrap(value): Instant)
      )(_.lastChangedDate)
      .optionallyWith(
        lastAccessedDate.map(value =>
          LastAccessedDateType.unwrap(value): Instant
        )
      )(_.lastAccessedDate)
      .optionallyWith(
        deletedDate.map(value => DeletedDateType.unwrap(value): Instant)
      )(_.deletedDate)
      .optionallyWith(
        nextRotationDate.map(value =>
          NextRotationDateType.unwrap(value): Instant
        )
      )(_.nextRotationDate)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        secretVersionsToStages.map(value =>
          value
            .map({ case (key, value) =>
              (SecretVersionIdType.unwrap(key): java.lang.String) -> value.map {
                item =>
                  SecretVersionStageType.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.secretVersionsToStages)
      .optionallyWith(
        owningService.map(value =>
          OwningServiceType.unwrap(value): java.lang.String
        )
      )(_.owningService)
      .optionallyWith(
        createdDate.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        primaryRegion.map(value => RegionType.unwrap(value): java.lang.String)
      )(_.primaryRegion)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.SecretListEntry.ReadOnly =
    zio.aws.secretsmanager.model.SecretListEntry.wrap(buildAwsValue())
}
object SecretListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.SecretListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.SecretListEntry =
      zio.aws.secretsmanager.model.SecretListEntry(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        kmsKeyId.map(value => value),
        rotationEnabled.map(value => value),
        rotationLambdaARN.map(value => value),
        rotationRules.map(value => value.asEditable),
        lastRotatedDate.map(value => value),
        lastChangedDate.map(value => value),
        lastAccessedDate.map(value => value),
        deletedDate.map(value => value),
        nextRotationDate.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secretVersionsToStages.map(value => value),
        owningService.map(value => value),
        createdDate.map(value => value),
        primaryRegion.map(value => value)
      )
    def arn: Optional[SecretARNType]
    def name: Optional[SecretNameType]
    def description: Optional[DescriptionType]
    def kmsKeyId: Optional[KmsKeyIdType]
    def rotationEnabled: Optional[RotationEnabledType]
    def rotationLambdaARN: Optional[RotationLambdaARNType]
    def rotationRules
        : Optional[zio.aws.secretsmanager.model.RotationRulesType.ReadOnly]
    def lastRotatedDate: Optional[LastRotatedDateType]
    def lastChangedDate: Optional[LastChangedDateType]
    def lastAccessedDate: Optional[LastAccessedDateType]
    def deletedDate: Optional[DeletedDateType]
    def nextRotationDate: Optional[NextRotationDateType]
    def tags: Optional[List[zio.aws.secretsmanager.model.Tag.ReadOnly]]
    def secretVersionsToStages
        : Optional[Map[SecretVersionIdType, List[SecretVersionStageType]]]
    def owningService: Optional[OwningServiceType]
    def createdDate: Optional[TimestampType]
    def primaryRegion: Optional[RegionType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyIdType] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getRotationEnabled: ZIO[Any, AwsError, RotationEnabledType] =
      AwsError.unwrapOptionField("rotationEnabled", rotationEnabled)
    def getRotationLambdaARN: ZIO[Any, AwsError, RotationLambdaARNType] =
      AwsError.unwrapOptionField("rotationLambdaARN", rotationLambdaARN)
    def getRotationRules: ZIO[
      Any,
      AwsError,
      zio.aws.secretsmanager.model.RotationRulesType.ReadOnly
    ] = AwsError.unwrapOptionField("rotationRules", rotationRules)
    def getLastRotatedDate: ZIO[Any, AwsError, LastRotatedDateType] =
      AwsError.unwrapOptionField("lastRotatedDate", lastRotatedDate)
    def getLastChangedDate: ZIO[Any, AwsError, LastChangedDateType] =
      AwsError.unwrapOptionField("lastChangedDate", lastChangedDate)
    def getLastAccessedDate: ZIO[Any, AwsError, LastAccessedDateType] =
      AwsError.unwrapOptionField("lastAccessedDate", lastAccessedDate)
    def getDeletedDate: ZIO[Any, AwsError, DeletedDateType] =
      AwsError.unwrapOptionField("deletedDate", deletedDate)
    def getNextRotationDate: ZIO[Any, AwsError, NextRotationDateType] =
      AwsError.unwrapOptionField("nextRotationDate", nextRotationDate)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.secretsmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSecretVersionsToStages
        : ZIO[Any, AwsError, Map[SecretVersionIdType, List[
          SecretVersionStageType
        ]]] = AwsError.unwrapOptionField(
      "secretVersionsToStages",
      secretVersionsToStages
    )
    def getOwningService: ZIO[Any, AwsError, OwningServiceType] =
      AwsError.unwrapOptionField("owningService", owningService)
    def getCreatedDate: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getPrimaryRegion: ZIO[Any, AwsError, RegionType] =
      AwsError.unwrapOptionField("primaryRegion", primaryRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.SecretListEntry
  ) extends zio.aws.secretsmanager.model.SecretListEntry.ReadOnly {
    override val arn: Optional[SecretARNType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Optional[SecretNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
    override val description: Optional[DescriptionType] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.DescriptionType(value)
      )
    override val kmsKeyId: Optional[KmsKeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.secretsmanager.model.primitives.KmsKeyIdType(value))
    override val rotationEnabled: Optional[RotationEnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rotationEnabled())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.RotationEnabledType(value)
        )
    override val rotationLambdaARN: Optional[RotationLambdaARNType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rotationLambdaARN())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.RotationLambdaARNType(value)
        )
    override val rotationRules
        : Optional[zio.aws.secretsmanager.model.RotationRulesType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rotationRules())
        .map(value =>
          zio.aws.secretsmanager.model.RotationRulesType.wrap(value)
        )
    override val lastRotatedDate: Optional[LastRotatedDateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRotatedDate())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.LastRotatedDateType(value)
        )
    override val lastChangedDate: Optional[LastChangedDateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastChangedDate())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.LastChangedDateType(value)
        )
    override val lastAccessedDate: Optional[LastAccessedDateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAccessedDate())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.LastAccessedDateType(value)
        )
    override val deletedDate: Optional[DeletedDateType] = zio.aws.core.internal
      .optionalFromNullable(impl.deletedDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.DeletedDateType(value)
      )
    override val nextRotationDate: Optional[NextRotationDateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextRotationDate())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.NextRotationDateType(value)
        )
    override val tags
        : Optional[List[zio.aws.secretsmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.secretsmanager.model.Tag.wrap(item)
          }.toList
        )
    override val secretVersionsToStages
        : Optional[Map[SecretVersionIdType, List[SecretVersionStageType]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretVersionsToStages())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.secretsmanager.model.primitives
                .SecretVersionIdType(key) -> value.asScala.map { item =>
                zio.aws.secretsmanager.model.primitives
                  .SecretVersionStageType(item)
              }.toList
            })
            .toMap
        )
    override val owningService: Optional[OwningServiceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owningService())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.OwningServiceType(value)
        )
    override val createdDate: Optional[TimestampType] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.TimestampType(value)
      )
    override val primaryRegion: Optional[RegionType] = zio.aws.core.internal
      .optionalFromNullable(impl.primaryRegion())
      .map(value => zio.aws.secretsmanager.model.primitives.RegionType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.SecretListEntry
  ): zio.aws.secretsmanager.model.SecretListEntry.ReadOnly = new Wrapper(impl)
}
