package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{SecretNameType, SecretARNType}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSecretVersionStageResponse(
    arn: Optional[SecretARNType] = Optional.Absent,
    name: Optional[SecretNameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageResponse = {
    import UpdateSecretVersionStageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse.ReadOnly =
    zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse
      .wrap(buildAwsValue())
}
object UpdateSecretVersionStageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse =
      zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse(
        arn.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[SecretARNType]
    def name: Optional[SecretNameType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageResponse
  ) extends zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse.ReadOnly {
    override val arn: Optional[SecretARNType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Optional[SecretNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageResponse
  ): zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse.ReadOnly =
    new Wrapper(impl)
}
