package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{ErrorMessage, NameType}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidationErrorsEntry(
    checkName: Optional[NameType] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ValidationErrorsEntry = {
    import ValidationErrorsEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ValidationErrorsEntry
      .builder()
      .optionallyWith(
        checkName.map(value => NameType.unwrap(value): java.lang.String)
      )(_.checkName)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.ValidationErrorsEntry.ReadOnly =
    zio.aws.secretsmanager.model.ValidationErrorsEntry.wrap(buildAwsValue())
}
object ValidationErrorsEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ValidationErrorsEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.ValidationErrorsEntry =
      zio.aws.secretsmanager.model.ValidationErrorsEntry(
        checkName.map(value => value),
        errorMessage.map(value => value)
      )
    def checkName: Optional[NameType]
    def errorMessage: Optional[ErrorMessage]
    def getCheckName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("checkName", checkName)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ValidationErrorsEntry
  ) extends zio.aws.secretsmanager.model.ValidationErrorsEntry.ReadOnly {
    override val checkName: Optional[NameType] = zio.aws.core.internal
      .optionalFromNullable(impl.checkName())
      .map(value => zio.aws.secretsmanager.model.primitives.NameType(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.secretsmanager.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ValidationErrorsEntry
  ): zio.aws.secretsmanager.model.ValidationErrorsEntry.ReadOnly = new Wrapper(
    impl
  )
}
