package zio.aws.secretsmanager.model
import scala.jdk.CollectionConverters._
sealed trait SortOrderType {
  def unwrap: software.amazon.awssdk.services.secretsmanager.model.SortOrderType
}
object SortOrderType {
  def wrap(
      value: software.amazon.awssdk.services.secretsmanager.model.SortOrderType
  ): zio.aws.secretsmanager.model.SortOrderType = value match {
    case software.amazon.awssdk.services.secretsmanager.model.SortOrderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.secretsmanager.model.SortOrderType.ASC =>
      val r = asc
      r
    case software.amazon.awssdk.services.secretsmanager.model.SortOrderType.DESC =>
      val r = desc
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.secretsmanager.model.SortOrderType {
    override def unwrap
        : software.amazon.awssdk.services.secretsmanager.model.SortOrderType =
      software.amazon.awssdk.services.secretsmanager.model.SortOrderType.UNKNOWN_TO_SDK_VERSION
  }
  case object asc extends zio.aws.secretsmanager.model.SortOrderType {
    override def unwrap
        : software.amazon.awssdk.services.secretsmanager.model.SortOrderType =
      software.amazon.awssdk.services.secretsmanager.model.SortOrderType.ASC
  }
  case object desc extends zio.aws.secretsmanager.model.SortOrderType {
    override def unwrap
        : software.amazon.awssdk.services.secretsmanager.model.SortOrderType =
      software.amazon.awssdk.services.secretsmanager.model.SortOrderType.DESC
  }
}
