package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  SecretVersionIdType,
  SecretNameType,
  SecretARNType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSecretResponse(
    arn: Optional[SecretARNType] = Optional.Absent,
    name: Optional[SecretNameType] = Optional.Absent,
    versionId: Optional[SecretVersionIdType] = Optional.Absent,
    replicationStatus: Optional[
      Iterable[zio.aws.secretsmanager.model.ReplicationStatusType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse = {
    import CreateSecretResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        versionId.map(value =>
          SecretVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .optionallyWith(
        replicationStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationStatus)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.CreateSecretResponse.ReadOnly =
    zio.aws.secretsmanager.model.CreateSecretResponse.wrap(buildAwsValue())
}
object CreateSecretResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.CreateSecretResponse =
      zio.aws.secretsmanager.model.CreateSecretResponse(
        arn.map(value => value),
        name.map(value => value),
        versionId.map(value => value),
        replicationStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Optional[SecretARNType]
    def name: Optional[SecretNameType]
    def versionId: Optional[SecretVersionIdType]
    def replicationStatus: Optional[
      List[zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly]
    ]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
    def getVersionId: ZIO[Any, AwsError, SecretVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getReplicationStatus: ZIO[Any, AwsError, List[
      zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly
    ]] = AwsError.unwrapOptionField("replicationStatus", replicationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse
  ) extends zio.aws.secretsmanager.model.CreateSecretResponse.ReadOnly {
    override val arn: Optional[SecretARNType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Optional[SecretNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
    override val versionId: Optional[SecretVersionIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionId())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.SecretVersionIdType(value)
        )
    override val replicationStatus: Optional[
      List[zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.ReplicationStatusType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse
  ): zio.aws.secretsmanager.model.CreateSecretResponse.ReadOnly = new Wrapper(
    impl
  )
}
