package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  NonEmptyResourcePolicyType,
  NameType,
  SecretARNType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourcePolicyResponse(
    arn: Optional[SecretARNType] = Optional.Absent,
    name: Optional[NameType] = Optional.Absent,
    resourcePolicy: Optional[NonEmptyResourcePolicyType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyResponse = {
    import GetResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => NameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        resourcePolicy.map(value =>
          NonEmptyResourcePolicyType.unwrap(value): java.lang.String
        )
      )(_.resourcePolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.GetResourcePolicyResponse.ReadOnly =
    zio.aws.secretsmanager.model.GetResourcePolicyResponse.wrap(buildAwsValue())
}
object GetResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.GetResourcePolicyResponse =
      zio.aws.secretsmanager.model.GetResourcePolicyResponse(
        arn.map(value => value),
        name.map(value => value),
        resourcePolicy.map(value => value)
      )
    def arn: Optional[SecretARNType]
    def name: Optional[NameType]
    def resourcePolicy: Optional[NonEmptyResourcePolicyType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("name", name)
    def getResourcePolicy: ZIO[Any, AwsError, NonEmptyResourcePolicyType] =
      AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyResponse
  ) extends zio.aws.secretsmanager.model.GetResourcePolicyResponse.ReadOnly {
    override val arn: Optional[SecretARNType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Optional[NameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.secretsmanager.model.primitives.NameType(value))
    override val resourcePolicy: Optional[NonEmptyResourcePolicyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcePolicy())
        .map(value =>
          zio.aws.secretsmanager.model.primitives
            .NonEmptyResourcePolicyType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyResponse
  ): zio.aws.secretsmanager.model.GetResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
