package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{KmsKeyIdType, RegionType}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicaRegionType(
    region: Optional[RegionType] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyIdType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ReplicaRegionType = {
    import ReplicaRegionType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ReplicaRegionType
      .builder()
      .optionallyWith(
        region.map(value => RegionType.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyIdType.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly =
    zio.aws.secretsmanager.model.ReplicaRegionType.wrap(buildAwsValue())
}
object ReplicaRegionType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ReplicaRegionType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.ReplicaRegionType =
      zio.aws.secretsmanager.model.ReplicaRegionType(
        region.map(value => value),
        kmsKeyId.map(value => value)
      )
    def region: Optional[RegionType]
    def kmsKeyId: Optional[KmsKeyIdType]
    def getRegion: ZIO[Any, AwsError, RegionType] =
      AwsError.unwrapOptionField("region", region)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyIdType] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ReplicaRegionType
  ) extends zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly {
    override val region: Optional[RegionType] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.secretsmanager.model.primitives.RegionType(value))
    override val kmsKeyId: Optional[KmsKeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.secretsmanager.model.primitives.KmsKeyIdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ReplicaRegionType
  ): zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly = new Wrapper(impl)
}
