package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.FilterValueStringType
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Filter(
    key: Optional[zio.aws.secretsmanager.model.FilterNameStringType] =
      Optional.Absent,
    values: Optional[Iterable[FilterValueStringType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.Filter
      .builder()
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            FilterValueStringType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.Filter.ReadOnly =
    zio.aws.secretsmanager.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.Filter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.Filter =
      zio.aws.secretsmanager.model
        .Filter(key.map(value => value), values.map(value => value))
    def key: Optional[zio.aws.secretsmanager.model.FilterNameStringType]
    def values: Optional[List[FilterValueStringType]]
    def getKey: ZIO[
      Any,
      AwsError,
      zio.aws.secretsmanager.model.FilterNameStringType
    ] = AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[FilterValueStringType]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.Filter
  ) extends zio.aws.secretsmanager.model.Filter.ReadOnly {
    override val key
        : Optional[zio.aws.secretsmanager.model.FilterNameStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.key())
        .map(value =>
          zio.aws.secretsmanager.model.FilterNameStringType.wrap(value)
        )
    override val values: Optional[List[FilterValueStringType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.secretsmanager.model.primitives.FilterValueStringType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.Filter
  ): zio.aws.secretsmanager.model.Filter.ReadOnly = new Wrapper(impl)
}
