package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{NameType, SecretARNType}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutResourcePolicyResponse(
    arn: Optional[SecretARNType] = Optional.Absent,
    name: Optional[NameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyResponse = {
    import PutResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => NameType.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.PutResourcePolicyResponse.ReadOnly =
    zio.aws.secretsmanager.model.PutResourcePolicyResponse.wrap(buildAwsValue())
}
object PutResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.PutResourcePolicyResponse =
      zio.aws.secretsmanager.model.PutResourcePolicyResponse(
        arn.map(value => value),
        name.map(value => value)
      )
    def arn: Optional[SecretARNType]
    def name: Optional[NameType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyResponse
  ) extends zio.aws.secretsmanager.model.PutResourcePolicyResponse.ReadOnly {
    override val arn: Optional[SecretARNType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Optional[NameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.secretsmanager.model.primitives.NameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.PutResourcePolicyResponse
  ): zio.aws.secretsmanager.model.PutResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
