package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.SecretIdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetResourcePolicyRequest(secretId: SecretIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyRequest = {
    import GetResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.GetResourcePolicyRequest.ReadOnly =
    zio.aws.secretsmanager.model.GetResourcePolicyRequest.wrap(buildAwsValue())
}
object GetResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.GetResourcePolicyRequest =
      zio.aws.secretsmanager.model.GetResourcePolicyRequest(secretId)
    def secretId: SecretIdType
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyRequest
  ) extends zio.aws.secretsmanager.model.GetResourcePolicyRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyRequest
  ): zio.aws.secretsmanager.model.GetResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
