package zio.aws.secretsmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.secretsmanager.model.primitives.{
  LastAccessedDateType,
  SecretVersionIdType,
  KmsKeyIdType,
  SecretVersionStageType,
  CreatedDateType
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class SecretVersionsListEntry(
    versionId: Optional[SecretVersionIdType] = Optional.Absent,
    versionStages: Optional[Iterable[SecretVersionStageType]] = Optional.Absent,
    lastAccessedDate: Optional[LastAccessedDateType] = Optional.Absent,
    createdDate: Optional[CreatedDateType] = Optional.Absent,
    kmsKeyIds: Optional[Iterable[KmsKeyIdType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.SecretVersionsListEntry = {
    import SecretVersionsListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.SecretVersionsListEntry
      .builder()
      .optionallyWith(
        versionId.map(value =>
          SecretVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .optionallyWith(
        versionStages.map(value =>
          value.map { item =>
            SecretVersionStageType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versionStages)
      .optionallyWith(
        lastAccessedDate.map(value =>
          LastAccessedDateType.unwrap(value): Instant
        )
      )(_.lastAccessedDate)
      .optionallyWith(
        createdDate.map(value => CreatedDateType.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        kmsKeyIds.map(value =>
          value.map { item =>
            KmsKeyIdType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.kmsKeyIds)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.SecretVersionsListEntry.ReadOnly =
    zio.aws.secretsmanager.model.SecretVersionsListEntry.wrap(buildAwsValue())
}
object SecretVersionsListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.SecretVersionsListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.SecretVersionsListEntry =
      zio.aws.secretsmanager.model.SecretVersionsListEntry(
        versionId.map(value => value),
        versionStages.map(value => value),
        lastAccessedDate.map(value => value),
        createdDate.map(value => value),
        kmsKeyIds.map(value => value)
      )
    def versionId: Optional[SecretVersionIdType]
    def versionStages: Optional[List[SecretVersionStageType]]
    def lastAccessedDate: Optional[LastAccessedDateType]
    def createdDate: Optional[CreatedDateType]
    def kmsKeyIds: Optional[List[KmsKeyIdType]]
    def getVersionId: ZIO[Any, AwsError, SecretVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getVersionStages: ZIO[Any, AwsError, List[SecretVersionStageType]] =
      AwsError.unwrapOptionField("versionStages", versionStages)
    def getLastAccessedDate: ZIO[Any, AwsError, LastAccessedDateType] =
      AwsError.unwrapOptionField("lastAccessedDate", lastAccessedDate)
    def getCreatedDate: ZIO[Any, AwsError, CreatedDateType] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getKmsKeyIds: ZIO[Any, AwsError, List[KmsKeyIdType]] =
      AwsError.unwrapOptionField("kmsKeyIds", kmsKeyIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.SecretVersionsListEntry
  ) extends zio.aws.secretsmanager.model.SecretVersionsListEntry.ReadOnly {
    override val versionId: Optional[SecretVersionIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionId())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.SecretVersionIdType(value)
        )
    override val versionStages: Optional[List[SecretVersionStageType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionStages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.secretsmanager.model.primitives.SecretVersionStageType(item)
          }.toList
        )
    override val lastAccessedDate: Optional[LastAccessedDateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAccessedDate())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.LastAccessedDateType(value)
        )
    override val createdDate: Optional[CreatedDateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.CreatedDateType(value)
      )
    override val kmsKeyIds: Optional[List[KmsKeyIdType]] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.primitives.KmsKeyIdType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.SecretVersionsListEntry
  ): zio.aws.secretsmanager.model.SecretVersionsListEntry.ReadOnly =
    new Wrapper(impl)
}
