package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  NameType,
  BooleanType,
  SecretBinaryType,
  ClientRequestTokenType,
  KmsKeyIdType,
  DescriptionType,
  SecretStringType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSecretRequest(
    name: NameType,
    clientRequestToken: Optional[ClientRequestTokenType] = Optional.Absent,
    description: Optional[DescriptionType] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyIdType] = Optional.Absent,
    secretBinary: Optional[SecretBinaryType] = Optional.Absent,
    secretString: Optional[SecretStringType] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.secretsmanager.model.Tag]] =
      Optional.Absent,
    addReplicaRegions: Optional[
      Iterable[zio.aws.secretsmanager.model.ReplicaRegionType]
    ] = Optional.Absent,
    forceOverwriteReplicaSecret: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest = {
    import CreateSecretRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest
      .builder()
      .name(NameType.unwrap(name): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenType.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyIdType.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        secretBinary.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.secretBinary)
      .optionallyWith(
        secretString.map(value =>
          SecretStringType.unwrap(value): java.lang.String
        )
      )(_.secretString)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addReplicaRegions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addReplicaRegions)
      .optionallyWith(
        forceOverwriteReplicaSecret.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.forceOverwriteReplicaSecret)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.CreateSecretRequest.ReadOnly =
    zio.aws.secretsmanager.model.CreateSecretRequest.wrap(buildAwsValue())
}
object CreateSecretRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.CreateSecretRequest =
      zio.aws.secretsmanager.model.CreateSecretRequest(
        name,
        clientRequestToken.map(value => value),
        description.map(value => value),
        kmsKeyId.map(value => value),
        secretBinary.map(value => value),
        secretString.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addReplicaRegions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        forceOverwriteReplicaSecret.map(value => value)
      )
    def name: NameType
    def clientRequestToken: Optional[ClientRequestTokenType]
    def description: Optional[DescriptionType]
    def kmsKeyId: Optional[KmsKeyIdType]
    def secretBinary: Optional[SecretBinaryType]
    def secretString: Optional[SecretStringType]
    def tags: Optional[List[zio.aws.secretsmanager.model.Tag.ReadOnly]]
    def addReplicaRegions: Optional[
      List[zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly]
    ]
    def forceOverwriteReplicaSecret: Optional[BooleanType]
    def getName: ZIO[Any, Nothing, NameType] = ZIO.succeed(name)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenType] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyIdType] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSecretBinary: ZIO[Any, AwsError, SecretBinaryType] =
      AwsError.unwrapOptionField("secretBinary", secretBinary)
    def getSecretString: ZIO[Any, AwsError, SecretStringType] =
      AwsError.unwrapOptionField("secretString", secretString)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.secretsmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAddReplicaRegions: ZIO[Any, AwsError, List[
      zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly
    ]] = AwsError.unwrapOptionField("addReplicaRegions", addReplicaRegions)
    def getForceOverwriteReplicaSecret: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "forceOverwriteReplicaSecret",
        forceOverwriteReplicaSecret
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest
  ) extends zio.aws.secretsmanager.model.CreateSecretRequest.ReadOnly {
    override val name: NameType =
      zio.aws.secretsmanager.model.primitives.NameType(impl.name())
    override val clientRequestToken: Optional[ClientRequestTokenType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.ClientRequestTokenType(value)
        )
    override val description: Optional[DescriptionType] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.DescriptionType(value)
      )
    override val kmsKeyId: Optional[KmsKeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.secretsmanager.model.primitives.KmsKeyIdType(value))
    override val secretBinary: Optional[SecretBinaryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretBinary())
        .map(value =>
          zio.aws.secretsmanager.model.primitives
            .SecretBinaryType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val secretString: Optional[SecretStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretString())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.SecretStringType(value)
        )
    override val tags
        : Optional[List[zio.aws.secretsmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.secretsmanager.model.Tag.wrap(item)
          }.toList
        )
    override val addReplicaRegions: Optional[
      List[zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.addReplicaRegions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.ReplicaRegionType.wrap(item)
        }.toList
      )
    override val forceOverwriteReplicaSecret: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forceOverwriteReplicaSecret())
        .map(value =>
          zio.aws.secretsmanager.model.primitives.BooleanType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest
  ): zio.aws.secretsmanager.model.CreateSecretRequest.ReadOnly = new Wrapper(
    impl
  )
}
