package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{RegionType, SecretIdType}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveRegionsFromReplicationRequest(
    secretId: SecretIdType,
    removeReplicaRegions: Iterable[RegionType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationRequest = {
    import RemoveRegionsFromReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .removeReplicaRegions(removeReplicaRegions.map { item =>
        RegionType.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.RemoveRegionsFromReplicationRequest.ReadOnly =
    zio.aws.secretsmanager.model.RemoveRegionsFromReplicationRequest
      .wrap(buildAwsValue())
}
object RemoveRegionsFromReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.secretsmanager.model.RemoveRegionsFromReplicationRequest =
      zio.aws.secretsmanager.model
        .RemoveRegionsFromReplicationRequest(secretId, removeReplicaRegions)
    def secretId: SecretIdType
    def removeReplicaRegions: List[RegionType]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getRemoveReplicaRegions: ZIO[Any, Nothing, List[RegionType]] =
      ZIO.succeed(removeReplicaRegions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationRequest
  ) extends zio.aws.secretsmanager.model.RemoveRegionsFromReplicationRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val removeReplicaRegions: List[RegionType] = impl
      .removeReplicaRegions()
      .asScala
      .map { item =>
        zio.aws.secretsmanager.model.primitives.RegionType(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationRequest
  ): zio.aws.secretsmanager.model.RemoveRegionsFromReplicationRequest.ReadOnly =
    new Wrapper(impl)
}
