package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  SecretNameType,
  SecretARNType,
  NextTokenType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListSecretVersionIdsResponse(
    versions: Optional[
      Iterable[zio.aws.secretsmanager.model.SecretVersionsListEntry]
    ] = Optional.Absent,
    nextToken: Optional[NextTokenType] = Optional.Absent,
    arn: Optional[SecretARNType] = Optional.Absent,
    name: Optional[SecretNameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsResponse = {
    import ListSecretVersionIdsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsResponse
      .builder()
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        nextToken.map(value => NextTokenType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly =
    zio.aws.secretsmanager.model.ListSecretVersionIdsResponse
      .wrap(buildAwsValue())
}
object ListSecretVersionIdsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.ListSecretVersionIdsResponse =
      zio.aws.secretsmanager.model.ListSecretVersionIdsResponse(
        versions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        arn.map(value => value),
        name.map(value => value)
      )
    def versions: Optional[
      List[zio.aws.secretsmanager.model.SecretVersionsListEntry.ReadOnly]
    ]
    def nextToken: Optional[NextTokenType]
    def arn: Optional[SecretARNType]
    def name: Optional[SecretNameType]
    def getVersions: ZIO[Any, AwsError, List[
      zio.aws.secretsmanager.model.SecretVersionsListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("versions", versions)
    def getNextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsResponse
  ) extends zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly {
    override val versions: Optional[
      List[zio.aws.secretsmanager.model.SecretVersionsListEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.SecretVersionsListEntry.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextTokenType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.NextTokenType(value)
      )
    override val arn: Optional[SecretARNType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Optional[SecretNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsResponse
  ): zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly =
    new Wrapper(impl)
}
