package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.SecretIdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSecretRequest(secretId: SecretIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.DescribeSecretRequest = {
    import DescribeSecretRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.DescribeSecretRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.DescribeSecretRequest.ReadOnly =
    zio.aws.secretsmanager.model.DescribeSecretRequest.wrap(buildAwsValue())
}
object DescribeSecretRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.DescribeSecretRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.DescribeSecretRequest =
      zio.aws.secretsmanager.model.DescribeSecretRequest(secretId)
    def secretId: SecretIdType
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.DescribeSecretRequest
  ) extends zio.aws.secretsmanager.model.DescribeSecretRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.DescribeSecretRequest
  ): zio.aws.secretsmanager.model.DescribeSecretRequest.ReadOnly = new Wrapper(
    impl
  )
}
