package zio.aws.secretsmanager
import zio.aws.secretsmanager.model.DeleteResourcePolicyResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.aws.secretsmanager.model.{
  RestoreSecretRequest,
  RemoveRegionsFromReplicationRequest,
  GetRandomPasswordRequest,
  GetSecretValueRequest,
  DeleteSecretRequest,
  PutResourcePolicyRequest,
  ReplicateSecretToRegionsRequest,
  CancelRotateSecretRequest,
  RotateSecretRequest,
  DescribeSecretRequest,
  UpdateSecretVersionStageRequest,
  ListSecretVersionIdsRequest,
  DeleteResourcePolicyRequest,
  UntagResourceRequest,
  ValidateResourcePolicyRequest,
  CreateSecretRequest,
  UpdateSecretRequest,
  PutSecretValueRequest,
  GetResourcePolicyRequest,
  StopReplicationToReplicaRequest,
  TagResourceRequest,
  ListSecretsRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient
object SecretsManagerMock extends Mock[SecretsManager] {
  object RotateSecret
      extends Effect[
        RotateSecretRequest,
        AwsError,
        zio.aws.secretsmanager.model.RotateSecretResponse.ReadOnly
      ]
  object ReplicateSecretToRegions
      extends Effect[
        ReplicateSecretToRegionsRequest,
        AwsError,
        zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse.ReadOnly
      ]
  object StopReplicationToReplica
      extends Effect[
        StopReplicationToReplicaRequest,
        AwsError,
        zio.aws.secretsmanager.model.StopReplicationToReplicaResponse.ReadOnly
      ]
  object DeleteSecret
      extends Effect[
        DeleteSecretRequest,
        AwsError,
        zio.aws.secretsmanager.model.DeleteSecretResponse.ReadOnly
      ]
  object PutSecretValue
      extends Effect[
        PutSecretValueRequest,
        AwsError,
        zio.aws.secretsmanager.model.PutSecretValueResponse.ReadOnly
      ]
  object GetSecretValue
      extends Effect[
        GetSecretValueRequest,
        AwsError,
        zio.aws.secretsmanager.model.GetSecretValueResponse.ReadOnly
      ]
  object CreateSecret
      extends Effect[
        CreateSecretRequest,
        AwsError,
        zio.aws.secretsmanager.model.CreateSecretResponse.ReadOnly
      ]
  object DescribeSecret
      extends Effect[
        DescribeSecretRequest,
        AwsError,
        zio.aws.secretsmanager.model.DescribeSecretResponse.ReadOnly
      ]
  object PutResourcePolicy
      extends Effect[
        PutResourcePolicyRequest,
        AwsError,
        zio.aws.secretsmanager.model.PutResourcePolicyResponse.ReadOnly
      ]
  object CancelRotateSecret
      extends Effect[
        CancelRotateSecretRequest,
        AwsError,
        zio.aws.secretsmanager.model.CancelRotateSecretResponse.ReadOnly
      ]
  object GetRandomPassword
      extends Effect[
        GetRandomPasswordRequest,
        AwsError,
        zio.aws.secretsmanager.model.GetRandomPasswordResponse.ReadOnly
      ]
  object ListSecrets
      extends Stream[
        ListSecretsRequest,
        AwsError,
        zio.aws.secretsmanager.model.SecretListEntry.ReadOnly
      ]
  object ListSecretsPaginated
      extends Effect[
        ListSecretsRequest,
        AwsError,
        zio.aws.secretsmanager.model.ListSecretsResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object ValidateResourcePolicy
      extends Effect[
        ValidateResourcePolicyRequest,
        AwsError,
        zio.aws.secretsmanager.model.ValidateResourcePolicyResponse.ReadOnly
      ]
  object UpdateSecretVersionStage
      extends Effect[
        UpdateSecretVersionStageRequest,
        AwsError,
        zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse.ReadOnly
      ]
  object DeleteResourcePolicy
      extends Effect[DeleteResourcePolicyRequest, AwsError, ReadOnly]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object RestoreSecret
      extends Effect[
        RestoreSecretRequest,
        AwsError,
        zio.aws.secretsmanager.model.RestoreSecretResponse.ReadOnly
      ]
  object GetResourcePolicy
      extends Effect[
        GetResourcePolicyRequest,
        AwsError,
        zio.aws.secretsmanager.model.GetResourcePolicyResponse.ReadOnly
      ]
  object UpdateSecret
      extends Effect[
        UpdateSecretRequest,
        AwsError,
        zio.aws.secretsmanager.model.UpdateSecretResponse.ReadOnly
      ]
  object RemoveRegionsFromReplication
      extends Effect[
        RemoveRegionsFromReplicationRequest,
        AwsError,
        zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse.ReadOnly
      ]
  object ListSecretVersionIds
      extends Effect[
        ListSecretVersionIdsRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly,
          zio.aws.secretsmanager.model.SecretVersionsListEntry.ReadOnly
        ]
      ]
  object ListSecretVersionIdsPaginated
      extends Effect[
        ListSecretVersionIdsRequest,
        AwsError,
        zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SecretsManager] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SecretsManager] { rts =>
        ZIO.succeed {
          new SecretsManager {
            val api: SecretsManagerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SecretsManager = this
            def rotateSecret(request: RotateSecretRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.RotateSecretResponse.ReadOnly
            ] = proxy(RotateSecret, request)
            def replicateSecretToRegions(
                request: ReplicateSecretToRegionsRequest
            ): IO[
              AwsError,
              zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse.ReadOnly
            ] = proxy(ReplicateSecretToRegions, request)
            def stopReplicationToReplica(
                request: StopReplicationToReplicaRequest
            ): IO[
              AwsError,
              zio.aws.secretsmanager.model.StopReplicationToReplicaResponse.ReadOnly
            ] = proxy(StopReplicationToReplica, request)
            def deleteSecret(request: DeleteSecretRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.DeleteSecretResponse.ReadOnly
            ] = proxy(DeleteSecret, request)
            def putSecretValue(request: PutSecretValueRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.PutSecretValueResponse.ReadOnly
            ] = proxy(PutSecretValue, request)
            def getSecretValue(request: GetSecretValueRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.GetSecretValueResponse.ReadOnly
            ] = proxy(GetSecretValue, request)
            def createSecret(request: CreateSecretRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.CreateSecretResponse.ReadOnly
            ] = proxy(CreateSecret, request)
            def describeSecret(request: DescribeSecretRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.DescribeSecretResponse.ReadOnly
            ] = proxy(DescribeSecret, request)
            def putResourcePolicy(request: PutResourcePolicyRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.PutResourcePolicyResponse.ReadOnly
            ] = proxy(PutResourcePolicy, request)
            def cancelRotateSecret(request: CancelRotateSecretRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.CancelRotateSecretResponse.ReadOnly
            ] = proxy(CancelRotateSecret, request)
            def getRandomPassword(request: GetRandomPasswordRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.GetRandomPasswordResponse.ReadOnly
            ] = proxy(GetRandomPassword, request)
            def listSecrets(request: ListSecretsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.secretsmanager.model.SecretListEntry.ReadOnly
            ] = rts.unsafeRun(proxy(ListSecrets, request))
            def listSecretsPaginated(request: ListSecretsRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.ListSecretsResponse.ReadOnly
            ] = proxy(ListSecretsPaginated, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def validateResourcePolicy(
                request: ValidateResourcePolicyRequest
            ): IO[
              AwsError,
              zio.aws.secretsmanager.model.ValidateResourcePolicyResponse.ReadOnly
            ] = proxy(ValidateResourcePolicy, request)
            def updateSecretVersionStage(
                request: UpdateSecretVersionStageRequest
            ): IO[
              AwsError,
              zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse.ReadOnly
            ] = proxy(UpdateSecretVersionStage, request)
            def deleteResourcePolicy(
                request: DeleteResourcePolicyRequest
            ): IO[AwsError, ReadOnly] = proxy(DeleteResourcePolicy, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def restoreSecret(request: RestoreSecretRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.RestoreSecretResponse.ReadOnly
            ] = proxy(RestoreSecret, request)
            def getResourcePolicy(request: GetResourcePolicyRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.GetResourcePolicyResponse.ReadOnly
            ] = proxy(GetResourcePolicy, request)
            def updateSecret(request: UpdateSecretRequest): IO[
              AwsError,
              zio.aws.secretsmanager.model.UpdateSecretResponse.ReadOnly
            ] = proxy(UpdateSecret, request)
            def removeRegionsFromReplication(
                request: RemoveRegionsFromReplicationRequest
            ): IO[
              AwsError,
              zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse.ReadOnly
            ] = proxy(RemoveRegionsFromReplication, request)
            def listSecretVersionIds(
                request: ListSecretVersionIdsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly,
              zio.aws.secretsmanager.model.SecretVersionsListEntry.ReadOnly
            ]] = proxy(ListSecretVersionIds, request)
            def listSecretVersionIdsPaginated(
                request: ListSecretVersionIdsRequest
            ): IO[
              AwsError,
              zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly
            ] = proxy(ListSecretVersionIdsPaginated, request)
          }
        }
      }
    }
  }
}
