package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.SecretIdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RestoreSecretRequest(secretId: SecretIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest = {
    import RestoreSecretRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.RestoreSecretRequest.ReadOnly =
    zio.aws.secretsmanager.model.RestoreSecretRequest.wrap(buildAwsValue())
}
object RestoreSecretRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.RestoreSecretRequest =
      zio.aws.secretsmanager.model.RestoreSecretRequest(secretId)
    def secretId: SecretIdType
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest
  ) extends zio.aws.secretsmanager.model.RestoreSecretRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest
  ): zio.aws.secretsmanager.model.RestoreSecretRequest.ReadOnly = new Wrapper(
    impl
  )
}
