package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.SecretARNType
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplicateSecretToRegionsResponse(
    arn: Optional[SecretARNType] = Optional.Absent,
    replicationStatus: Optional[
      Iterable[zio.aws.secretsmanager.model.ReplicationStatusType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsResponse = {
    import ReplicateSecretToRegionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        replicationStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse.ReadOnly =
    zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse
      .wrap(buildAwsValue())
}
object ReplicateSecretToRegionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse =
      zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse(
        arn.map(value => value),
        replicationStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Optional[SecretARNType]
    def replicationStatus: Optional[
      List[zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly]
    ]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getReplicationStatus: ZIO[Any, AwsError, List[
      zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly
    ]] = AwsError.unwrapOptionField("replicationStatus", replicationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsResponse
  ) extends zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse.ReadOnly {
    override val arn: Optional[SecretARNType] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val replicationStatus: Optional[
      List[zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.ReplicationStatusType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsResponse
  ): zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse.ReadOnly =
    new Wrapper(impl)
}
