package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.SecretIdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteResourcePolicyRequest(secretId: SecretIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyRequest = {
    import DeleteResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.DeleteResourcePolicyRequest.ReadOnly =
    zio.aws.secretsmanager.model.DeleteResourcePolicyRequest
      .wrap(buildAwsValue())
}
object DeleteResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.DeleteResourcePolicyRequest =
      zio.aws.secretsmanager.model.DeleteResourcePolicyRequest(secretId)
    def secretId: SecretIdType
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyRequest
  ) extends zio.aws.secretsmanager.model.DeleteResourcePolicyRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.DeleteResourcePolicyRequest
  ): zio.aws.secretsmanager.model.DeleteResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
