package zio.aws.secretsmanager.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.secretsmanager.model.primitives.{NextTokenType, MaxResultsType}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSecretsRequest(
    maxResults: Optional[MaxResultsType] = Optional.Absent,
    nextToken: Optional[NextTokenType] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.secretsmanager.model.Filter]] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.secretsmanager.model.SortOrderType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest = {
    import ListSecretsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResultsType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextTokenType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.ListSecretsRequest.ReadOnly =
    zio.aws.secretsmanager.model.ListSecretsRequest.wrap(buildAwsValue())
}
object ListSecretsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.ListSecretsRequest =
      zio.aws.secretsmanager.model.ListSecretsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortOrder.map(value => value)
      )
    def maxResults: Optional[MaxResultsType]
    def nextToken: Optional[NextTokenType]
    def filters: Optional[List[zio.aws.secretsmanager.model.Filter.ReadOnly]]
    def sortOrder: Optional[zio.aws.secretsmanager.model.SortOrderType]
    def getMaxResults: ZIO[Any, AwsError, MaxResultsType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.secretsmanager.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.secretsmanager.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest
  ) extends zio.aws.secretsmanager.model.ListSecretsRequest.ReadOnly {
    override val maxResults: Optional[MaxResultsType] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.MaxResultsType(value)
      )
    override val nextToken: Optional[NextTokenType] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.NextTokenType(value)
      )
    override val filters
        : Optional[List[zio.aws.secretsmanager.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.secretsmanager.model.Filter.wrap(item)
          }.toList
        )
    override val sortOrder
        : Optional[zio.aws.secretsmanager.model.SortOrderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.secretsmanager.model.SortOrderType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest
  ): zio.aws.secretsmanager.model.ListSecretsRequest.ReadOnly = new Wrapper(
    impl
  )
}
