package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{BooleanType, SecretIdType}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReplicateSecretToRegionsRequest(
    secretId: SecretIdType,
    addReplicaRegions: Iterable[zio.aws.secretsmanager.model.ReplicaRegionType],
    forceOverwriteReplicaSecret: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsRequest = {
    import ReplicateSecretToRegionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .addReplicaRegions(addReplicaRegions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        forceOverwriteReplicaSecret.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.forceOverwriteReplicaSecret)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.ReplicateSecretToRegionsRequest.ReadOnly =
    zio.aws.secretsmanager.model.ReplicateSecretToRegionsRequest
      .wrap(buildAwsValue())
}
object ReplicateSecretToRegionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.secretsmanager.model.ReplicateSecretToRegionsRequest =
      zio.aws.secretsmanager.model.ReplicateSecretToRegionsRequest(
        secretId,
        addReplicaRegions.map { item =>
          item.asEditable
        },
        forceOverwriteReplicaSecret.map(value => value)
      )
    def secretId: SecretIdType
    def addReplicaRegions
        : List[zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly]
    def forceOverwriteReplicaSecret: Option[BooleanType]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getAddReplicaRegions: ZIO[Any, Nothing, List[
      zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly
    ]] = ZIO.succeed(addReplicaRegions)
    def getForceOverwriteReplicaSecret: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "forceOverwriteReplicaSecret",
        forceOverwriteReplicaSecret
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsRequest
  ) extends zio.aws.secretsmanager.model.ReplicateSecretToRegionsRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val addReplicaRegions
        : List[zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly] = impl
      .addReplicaRegions()
      .asScala
      .map { item =>
        zio.aws.secretsmanager.model.ReplicaRegionType.wrap(item)
      }
      .toList
    override val forceOverwriteReplicaSecret: Option[BooleanType] = scala
      .Option(impl.forceOverwriteReplicaSecret())
      .map(value => zio.aws.secretsmanager.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ReplicateSecretToRegionsRequest
  ): zio.aws.secretsmanager.model.ReplicateSecretToRegionsRequest.ReadOnly =
    new Wrapper(impl)
}
