package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  SecretVersionStageType,
  SecretVersionIdType,
  SecretNameType,
  SecretARNType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutSecretValueResponse(
    arn: Option[SecretARNType] = None,
    name: Option[SecretNameType] = None,
    versionId: Option[SecretVersionIdType] = None,
    versionStages: Option[Iterable[SecretVersionStageType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.PutSecretValueResponse = {
    import PutSecretValueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.PutSecretValueResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        versionId.map(value =>
          SecretVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .optionallyWith(
        versionStages.map(value =>
          value.map { item =>
            SecretVersionStageType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versionStages)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.PutSecretValueResponse.ReadOnly =
    zio.aws.secretsmanager.model.PutSecretValueResponse.wrap(buildAwsValue())
}
object PutSecretValueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.PutSecretValueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.PutSecretValueResponse =
      zio.aws.secretsmanager.model.PutSecretValueResponse(
        arn.map(value => value),
        name.map(value => value),
        versionId.map(value => value),
        versionStages.map(value => value)
      )
    def arn: Option[SecretARNType]
    def name: Option[SecretNameType]
    def versionId: Option[SecretVersionIdType]
    def versionStages: Option[List[SecretVersionStageType]]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
    def getVersionId: ZIO[Any, AwsError, SecretVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getVersionStages: ZIO[Any, AwsError, List[SecretVersionStageType]] =
      AwsError.unwrapOptionField("versionStages", versionStages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.PutSecretValueResponse
  ) extends zio.aws.secretsmanager.model.PutSecretValueResponse.ReadOnly {
    override val arn: Option[SecretARNType] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Option[SecretNameType] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
    override val versionId: Option[SecretVersionIdType] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretVersionIdType(value)
      )
    override val versionStages: Option[List[SecretVersionStageType]] = scala
      .Option(impl.versionStages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.primitives.SecretVersionStageType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.PutSecretValueResponse
  ): zio.aws.secretsmanager.model.PutSecretValueResponse.ReadOnly = new Wrapper(
    impl
  )
}
