package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  DeletionDateType,
  SecretNameType,
  SecretARNType
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DeleteSecretResponse(
    arn: Option[SecretARNType] = None,
    name: Option[SecretNameType] = None,
    deletionDate: Option[DeletionDateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.DeleteSecretResponse = {
    import DeleteSecretResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.DeleteSecretResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        deletionDate.map(value => DeletionDateType.unwrap(value): Instant)
      )(_.deletionDate)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.DeleteSecretResponse.ReadOnly =
    zio.aws.secretsmanager.model.DeleteSecretResponse.wrap(buildAwsValue())
}
object DeleteSecretResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.DeleteSecretResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.DeleteSecretResponse =
      zio.aws.secretsmanager.model.DeleteSecretResponse(
        arn.map(value => value),
        name.map(value => value),
        deletionDate.map(value => value)
      )
    def arn: Option[SecretARNType]
    def name: Option[SecretNameType]
    def deletionDate: Option[DeletionDateType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
    def getDeletionDate: ZIO[Any, AwsError, DeletionDateType] =
      AwsError.unwrapOptionField("deletionDate", deletionDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.DeleteSecretResponse
  ) extends zio.aws.secretsmanager.model.DeleteSecretResponse.ReadOnly {
    override val arn: Option[SecretARNType] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Option[SecretNameType] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
    override val deletionDate: Option[DeletionDateType] = scala
      .Option(impl.deletionDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.DeletionDateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.DeleteSecretResponse
  ): zio.aws.secretsmanager.model.DeleteSecretResponse.ReadOnly = new Wrapper(
    impl
  )
}
