package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  ScheduleExpressionType,
  DurationType,
  AutomaticallyRotateAfterDaysType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RotationRulesType(
    automaticallyAfterDays: Option[AutomaticallyRotateAfterDaysType] = None,
    duration: Option[DurationType] = None,
    scheduleExpression: Option[ScheduleExpressionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.RotationRulesType = {
    import RotationRulesType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.RotationRulesType
      .builder()
      .optionallyWith(
        automaticallyAfterDays.map(value =>
          AutomaticallyRotateAfterDaysType.unwrap(value): java.lang.Long
        )
      )(_.automaticallyAfterDays)
      .optionallyWith(
        duration.map(value => DurationType.unwrap(value): java.lang.String)
      )(_.duration)
      .optionallyWith(
        scheduleExpression.map(value =>
          ScheduleExpressionType.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.RotationRulesType.ReadOnly =
    zio.aws.secretsmanager.model.RotationRulesType.wrap(buildAwsValue())
}
object RotationRulesType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.RotationRulesType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.RotationRulesType =
      zio.aws.secretsmanager.model.RotationRulesType(
        automaticallyAfterDays.map(value => value),
        duration.map(value => value),
        scheduleExpression.map(value => value)
      )
    def automaticallyAfterDays: Option[AutomaticallyRotateAfterDaysType]
    def duration: Option[DurationType]
    def scheduleExpression: Option[ScheduleExpressionType]
    def getAutomaticallyAfterDays
        : ZIO[Any, AwsError, AutomaticallyRotateAfterDaysType] = AwsError
      .unwrapOptionField("automaticallyAfterDays", automaticallyAfterDays)
    def getDuration: ZIO[Any, AwsError, DurationType] =
      AwsError.unwrapOptionField("duration", duration)
    def getScheduleExpression: ZIO[Any, AwsError, ScheduleExpressionType] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.RotationRulesType
  ) extends zio.aws.secretsmanager.model.RotationRulesType.ReadOnly {
    override val automaticallyAfterDays
        : Option[AutomaticallyRotateAfterDaysType] = scala
      .Option(impl.automaticallyAfterDays())
      .map(value =>
        zio.aws.secretsmanager.model.primitives
          .AutomaticallyRotateAfterDaysType(value)
      )
    override val duration: Option[DurationType] = scala
      .Option(impl.duration())
      .map(value => zio.aws.secretsmanager.model.primitives.DurationType(value))
    override val scheduleExpression: Option[ScheduleExpressionType] = scala
      .Option(impl.scheduleExpression())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.ScheduleExpressionType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.RotationRulesType
  ): zio.aws.secretsmanager.model.RotationRulesType.ReadOnly = new Wrapper(impl)
}
