package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  SecretARNType,
  SecretVersionIdType,
  SecretBinaryType,
  SecretNameType,
  SecretVersionStageType,
  SecretStringType,
  CreatedDateType
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetSecretValueResponse(
    arn: Option[SecretARNType] = None,
    name: Option[SecretNameType] = None,
    versionId: Option[SecretVersionIdType] = None,
    secretBinary: Option[SecretBinaryType] = None,
    secretString: Option[SecretStringType] = None,
    versionStages: Option[Iterable[SecretVersionStageType]] = None,
    createdDate: Option[CreatedDateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse = {
    import GetSecretValueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        versionId.map(value =>
          SecretVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .optionallyWith(
        secretBinary.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.secretBinary)
      .optionallyWith(
        secretString.map(value =>
          SecretStringType.unwrap(value): java.lang.String
        )
      )(_.secretString)
      .optionallyWith(
        versionStages.map(value =>
          value.map { item =>
            SecretVersionStageType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versionStages)
      .optionallyWith(
        createdDate.map(value => CreatedDateType.unwrap(value): Instant)
      )(_.createdDate)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.GetSecretValueResponse.ReadOnly =
    zio.aws.secretsmanager.model.GetSecretValueResponse.wrap(buildAwsValue())
}
object GetSecretValueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.GetSecretValueResponse =
      zio.aws.secretsmanager.model.GetSecretValueResponse(
        arn.map(value => value),
        name.map(value => value),
        versionId.map(value => value),
        secretBinary.map(value => value),
        secretString.map(value => value),
        versionStages.map(value => value),
        createdDate.map(value => value)
      )
    def arn: Option[SecretARNType]
    def name: Option[SecretNameType]
    def versionId: Option[SecretVersionIdType]
    def secretBinary: Option[SecretBinaryType]
    def secretString: Option[SecretStringType]
    def versionStages: Option[List[SecretVersionStageType]]
    def createdDate: Option[CreatedDateType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
    def getVersionId: ZIO[Any, AwsError, SecretVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getSecretBinary: ZIO[Any, AwsError, SecretBinaryType] =
      AwsError.unwrapOptionField("secretBinary", secretBinary)
    def getSecretString: ZIO[Any, AwsError, SecretStringType] =
      AwsError.unwrapOptionField("secretString", secretString)
    def getVersionStages: ZIO[Any, AwsError, List[SecretVersionStageType]] =
      AwsError.unwrapOptionField("versionStages", versionStages)
    def getCreatedDate: ZIO[Any, AwsError, CreatedDateType] =
      AwsError.unwrapOptionField("createdDate", createdDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse
  ) extends zio.aws.secretsmanager.model.GetSecretValueResponse.ReadOnly {
    override val arn: Option[SecretARNType] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Option[SecretNameType] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
    override val versionId: Option[SecretVersionIdType] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretVersionIdType(value)
      )
    override val secretBinary: Option[SecretBinaryType] = scala
      .Option(impl.secretBinary())
      .map(value =>
        zio.aws.secretsmanager.model.primitives
          .SecretBinaryType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val secretString: Option[SecretStringType] = scala
      .Option(impl.secretString())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretStringType(value)
      )
    override val versionStages: Option[List[SecretVersionStageType]] = scala
      .Option(impl.versionStages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.primitives.SecretVersionStageType(item)
        }.toList
      )
    override val createdDate: Option[CreatedDateType] = scala
      .Option(impl.createdDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.CreatedDateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse
  ): zio.aws.secretsmanager.model.GetSecretValueResponse.ReadOnly = new Wrapper(
    impl
  )
}
