package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.SecretIdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelRotateSecretRequest(secretId: SecretIdType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.CancelRotateSecretRequest = {
    import CancelRotateSecretRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.CancelRotateSecretRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.CancelRotateSecretRequest.ReadOnly =
    zio.aws.secretsmanager.model.CancelRotateSecretRequest.wrap(buildAwsValue())
}
object CancelRotateSecretRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.CancelRotateSecretRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.CancelRotateSecretRequest =
      zio.aws.secretsmanager.model.CancelRotateSecretRequest(secretId)
    def secretId: SecretIdType
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.CancelRotateSecretRequest
  ) extends zio.aws.secretsmanager.model.CancelRotateSecretRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.CancelRotateSecretRequest
  ): zio.aws.secretsmanager.model.CancelRotateSecretRequest.ReadOnly =
    new Wrapper(impl)
}
