package zio.aws.secretsmanager
import software.amazon.awssdk.services.secretsmanager.model.{
  RestoreSecretResponse,
  GetSecretValueResponse,
  DescribeSecretResponse,
  GetResourcePolicyResponse,
  ValidateResourcePolicyResponse,
  RestoreSecretRequest,
  RemoveRegionsFromReplicationRequest,
  PutResourcePolicyResponse,
  GetRandomPasswordRequest,
  ReplicateSecretToRegionsResponse,
  GetSecretValueRequest,
  DeleteSecretRequest,
  DeleteSecretResponse,
  PutResourcePolicyRequest,
  StopReplicationToReplicaResponse,
  ListSecretVersionIdsResponse,
  ReplicateSecretToRegionsRequest,
  CancelRotateSecretRequest,
  UpdateSecretResponse,
  RotateSecretRequest,
  UntagResourceResponse,
  CancelRotateSecretResponse,
  SecretListEntry,
  SecretVersionsListEntry,
  DescribeSecretRequest,
  ListSecretsResponse,
  UpdateSecretVersionStageRequest,
  RemoveRegionsFromReplicationResponse,
  PutSecretValueResponse,
  ListSecretVersionIdsRequest,
  DeleteResourcePolicyRequest,
  UpdateSecretVersionStageResponse,
  UntagResourceRequest,
  GetRandomPasswordResponse,
  ValidateResourcePolicyRequest,
  CreateSecretRequest,
  UpdateSecretRequest,
  PutSecretValueRequest,
  CreateSecretResponse,
  GetResourcePolicyRequest,
  DeleteResourcePolicyResponse,
  TagResourceResponse,
  StopReplicationToReplicaRequest,
  TagResourceRequest,
  RotateSecretResponse,
  ListSecretsRequest
}
import zio.aws.secretsmanager.model.DeleteResourcePolicyResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.secretsmanager.{
  SecretsManagerAsyncClientBuilder,
  SecretsManagerAsyncClient
}
import scala.jdk.CollectionConverters._
trait SecretsManager extends AspectSupport[SecretsManager] {
  val api: SecretsManagerAsyncClient
  def rotateSecret(
      request: zio.aws.secretsmanager.model.RotateSecretRequest
  ): IO[AwsError, zio.aws.secretsmanager.model.RotateSecretResponse.ReadOnly]
  def replicateSecretToRegions(
      request: zio.aws.secretsmanager.model.ReplicateSecretToRegionsRequest
  ): IO[
    AwsError,
    zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse.ReadOnly
  ]
  def stopReplicationToReplica(
      request: zio.aws.secretsmanager.model.StopReplicationToReplicaRequest
  ): IO[
    AwsError,
    zio.aws.secretsmanager.model.StopReplicationToReplicaResponse.ReadOnly
  ]
  def deleteSecret(
      request: zio.aws.secretsmanager.model.DeleteSecretRequest
  ): IO[AwsError, zio.aws.secretsmanager.model.DeleteSecretResponse.ReadOnly]
  def putSecretValue(
      request: zio.aws.secretsmanager.model.PutSecretValueRequest
  ): IO[AwsError, zio.aws.secretsmanager.model.PutSecretValueResponse.ReadOnly]
  def getSecretValue(
      request: zio.aws.secretsmanager.model.GetSecretValueRequest
  ): IO[AwsError, zio.aws.secretsmanager.model.GetSecretValueResponse.ReadOnly]
  def createSecret(
      request: zio.aws.secretsmanager.model.CreateSecretRequest
  ): IO[AwsError, zio.aws.secretsmanager.model.CreateSecretResponse.ReadOnly]
  def describeSecret(
      request: zio.aws.secretsmanager.model.DescribeSecretRequest
  ): IO[AwsError, zio.aws.secretsmanager.model.DescribeSecretResponse.ReadOnly]
  def putResourcePolicy(
      request: zio.aws.secretsmanager.model.PutResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.secretsmanager.model.PutResourcePolicyResponse.ReadOnly
  ]
  def cancelRotateSecret(
      request: zio.aws.secretsmanager.model.CancelRotateSecretRequest
  ): IO[
    AwsError,
    zio.aws.secretsmanager.model.CancelRotateSecretResponse.ReadOnly
  ]
  def getRandomPassword(
      request: zio.aws.secretsmanager.model.GetRandomPasswordRequest
  ): IO[
    AwsError,
    zio.aws.secretsmanager.model.GetRandomPasswordResponse.ReadOnly
  ]
  def listSecrets(
      request: zio.aws.secretsmanager.model.ListSecretsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.secretsmanager.model.SecretListEntry.ReadOnly
  ]
  def listSecretsPaginated(
      request: zio.aws.secretsmanager.model.ListSecretsRequest
  ): IO[AwsError, zio.aws.secretsmanager.model.ListSecretsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.secretsmanager.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def validateResourcePolicy(
      request: zio.aws.secretsmanager.model.ValidateResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.secretsmanager.model.ValidateResourcePolicyResponse.ReadOnly
  ]
  def updateSecretVersionStage(
      request: zio.aws.secretsmanager.model.UpdateSecretVersionStageRequest
  ): IO[
    AwsError,
    zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse.ReadOnly
  ]
  def deleteResourcePolicy(
      request: zio.aws.secretsmanager.model.DeleteResourcePolicyRequest
  ): IO[AwsError, ReadOnly]
  def tagResource(
      request: zio.aws.secretsmanager.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def restoreSecret(
      request: zio.aws.secretsmanager.model.RestoreSecretRequest
  ): IO[AwsError, zio.aws.secretsmanager.model.RestoreSecretResponse.ReadOnly]
  def getResourcePolicy(
      request: zio.aws.secretsmanager.model.GetResourcePolicyRequest
  ): IO[
    AwsError,
    zio.aws.secretsmanager.model.GetResourcePolicyResponse.ReadOnly
  ]
  def updateSecret(
      request: zio.aws.secretsmanager.model.UpdateSecretRequest
  ): IO[AwsError, zio.aws.secretsmanager.model.UpdateSecretResponse.ReadOnly]
  def removeRegionsFromReplication(
      request: zio.aws.secretsmanager.model.RemoveRegionsFromReplicationRequest
  ): IO[
    AwsError,
    zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse.ReadOnly
  ]
  def listSecretVersionIds(
      request: zio.aws.secretsmanager.model.ListSecretVersionIdsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly,
    zio.aws.secretsmanager.model.SecretVersionsListEntry.ReadOnly
  ]]
  def listSecretVersionIdsPaginated(
      request: zio.aws.secretsmanager.model.ListSecretVersionIdsRequest
  ): IO[
    AwsError,
    zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly
  ]
}
object SecretsManager {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SecretsManager] = customized(
    identity
  )
  def customized(
      customization: SecretsManagerAsyncClientBuilder => SecretsManagerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SecretsManager] = managed(
    customization
  ).toLayer
  def managed(
      customization: SecretsManagerAsyncClientBuilder => SecretsManagerAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, SecretsManager] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = SecretsManagerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SecretsManagerAsyncClient, SecretsManagerAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        SecretsManagerAsyncClient,
        SecretsManagerAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new SecretsManagerImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class SecretsManagerImpl[R](
      override val api: SecretsManagerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SecretsManager
      with AwsServiceBase[R] {
    override val serviceName: String = "SecretsManager"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SecretsManagerImpl[R1] = new SecretsManagerImpl(api, newAspect, r)
    def rotateSecret(
        request: zio.aws.secretsmanager.model.RotateSecretRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.RotateSecretResponse.ReadOnly
    ] = asyncRequestResponse[RotateSecretRequest, RotateSecretResponse](
      "rotateSecret",
      api.rotateSecret
    )(request.buildAwsValue())
      .map(zio.aws.secretsmanager.model.RotateSecretResponse.wrap)
      .provideEnvironment(r)
    def replicateSecretToRegions(
        request: zio.aws.secretsmanager.model.ReplicateSecretToRegionsRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ReplicateSecretToRegionsRequest,
      ReplicateSecretToRegionsResponse
    ]("replicateSecretToRegions", api.replicateSecretToRegions)(
      request.buildAwsValue()
    ).map(zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse.wrap)
      .provideEnvironment(r)
    def stopReplicationToReplica(
        request: zio.aws.secretsmanager.model.StopReplicationToReplicaRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.StopReplicationToReplicaResponse.ReadOnly
    ] = asyncRequestResponse[
      StopReplicationToReplicaRequest,
      StopReplicationToReplicaResponse
    ]("stopReplicationToReplica", api.stopReplicationToReplica)(
      request.buildAwsValue()
    ).map(zio.aws.secretsmanager.model.StopReplicationToReplicaResponse.wrap)
      .provideEnvironment(r)
    def deleteSecret(
        request: zio.aws.secretsmanager.model.DeleteSecretRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.DeleteSecretResponse.ReadOnly
    ] = asyncRequestResponse[DeleteSecretRequest, DeleteSecretResponse](
      "deleteSecret",
      api.deleteSecret
    )(request.buildAwsValue())
      .map(zio.aws.secretsmanager.model.DeleteSecretResponse.wrap)
      .provideEnvironment(r)
    def putSecretValue(
        request: zio.aws.secretsmanager.model.PutSecretValueRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.PutSecretValueResponse.ReadOnly
    ] = asyncRequestResponse[PutSecretValueRequest, PutSecretValueResponse](
      "putSecretValue",
      api.putSecretValue
    )(request.buildAwsValue())
      .map(zio.aws.secretsmanager.model.PutSecretValueResponse.wrap)
      .provideEnvironment(r)
    def getSecretValue(
        request: zio.aws.secretsmanager.model.GetSecretValueRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.GetSecretValueResponse.ReadOnly
    ] = asyncRequestResponse[GetSecretValueRequest, GetSecretValueResponse](
      "getSecretValue",
      api.getSecretValue
    )(request.buildAwsValue())
      .map(zio.aws.secretsmanager.model.GetSecretValueResponse.wrap)
      .provideEnvironment(r)
    def createSecret(
        request: zio.aws.secretsmanager.model.CreateSecretRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.CreateSecretResponse.ReadOnly
    ] = asyncRequestResponse[CreateSecretRequest, CreateSecretResponse](
      "createSecret",
      api.createSecret
    )(request.buildAwsValue())
      .map(zio.aws.secretsmanager.model.CreateSecretResponse.wrap)
      .provideEnvironment(r)
    def describeSecret(
        request: zio.aws.secretsmanager.model.DescribeSecretRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.DescribeSecretResponse.ReadOnly
    ] = asyncRequestResponse[DescribeSecretRequest, DescribeSecretResponse](
      "describeSecret",
      api.describeSecret
    )(request.buildAwsValue())
      .map(zio.aws.secretsmanager.model.DescribeSecretResponse.wrap)
      .provideEnvironment(r)
    def putResourcePolicy(
        request: zio.aws.secretsmanager.model.PutResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.PutResourcePolicyResponse.ReadOnly
    ] =
      asyncRequestResponse[PutResourcePolicyRequest, PutResourcePolicyResponse](
        "putResourcePolicy",
        api.putResourcePolicy
      )(request.buildAwsValue())
        .map(zio.aws.secretsmanager.model.PutResourcePolicyResponse.wrap)
        .provideEnvironment(r)
    def cancelRotateSecret(
        request: zio.aws.secretsmanager.model.CancelRotateSecretRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.CancelRotateSecretResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelRotateSecretRequest,
      CancelRotateSecretResponse
    ]("cancelRotateSecret", api.cancelRotateSecret)(request.buildAwsValue())
      .map(zio.aws.secretsmanager.model.CancelRotateSecretResponse.wrap)
      .provideEnvironment(r)
    def getRandomPassword(
        request: zio.aws.secretsmanager.model.GetRandomPasswordRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.GetRandomPasswordResponse.ReadOnly
    ] =
      asyncRequestResponse[GetRandomPasswordRequest, GetRandomPasswordResponse](
        "getRandomPassword",
        api.getRandomPassword
      )(request.buildAwsValue())
        .map(zio.aws.secretsmanager.model.GetRandomPasswordResponse.wrap)
        .provideEnvironment(r)
    def listSecrets(
        request: zio.aws.secretsmanager.model.ListSecretsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.secretsmanager.model.SecretListEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListSecretsRequest,
      ListSecretsResponse,
      SecretListEntry
    ](
      "listSecrets",
      api.listSecrets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.secretList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.secretsmanager.model.SecretListEntry.wrap(item))
      .provideEnvironment(r)
    def listSecretsPaginated(
        request: zio.aws.secretsmanager.model.ListSecretsRequest
    ): IO[AwsError, zio.aws.secretsmanager.model.ListSecretsResponse.ReadOnly] =
      asyncRequestResponse[ListSecretsRequest, ListSecretsResponse](
        "listSecrets",
        api.listSecrets
      )(request.buildAwsValue())
        .map(zio.aws.secretsmanager.model.ListSecretsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.secretsmanager.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def validateResourcePolicy(
        request: zio.aws.secretsmanager.model.ValidateResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.ValidateResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      ValidateResourcePolicyRequest,
      ValidateResourcePolicyResponse
    ]("validateResourcePolicy", api.validateResourcePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.secretsmanager.model.ValidateResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def updateSecretVersionStage(
        request: zio.aws.secretsmanager.model.UpdateSecretVersionStageRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSecretVersionStageRequest,
      UpdateSecretVersionStageResponse
    ]("updateSecretVersionStage", api.updateSecretVersionStage)(
      request.buildAwsValue()
    ).map(zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse.wrap)
      .provideEnvironment(r)
    def deleteResourcePolicy(
        request: zio.aws.secretsmanager.model.DeleteResourcePolicyRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      DeleteResourcePolicyRequest,
      DeleteResourcePolicyResponse
    ]("deleteResourcePolicy", api.deleteResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.secretsmanager.model.DeleteResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.secretsmanager.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def restoreSecret(
        request: zio.aws.secretsmanager.model.RestoreSecretRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.RestoreSecretResponse.ReadOnly
    ] = asyncRequestResponse[RestoreSecretRequest, RestoreSecretResponse](
      "restoreSecret",
      api.restoreSecret
    )(request.buildAwsValue())
      .map(zio.aws.secretsmanager.model.RestoreSecretResponse.wrap)
      .provideEnvironment(r)
    def getResourcePolicy(
        request: zio.aws.secretsmanager.model.GetResourcePolicyRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.GetResourcePolicyResponse.ReadOnly
    ] =
      asyncRequestResponse[GetResourcePolicyRequest, GetResourcePolicyResponse](
        "getResourcePolicy",
        api.getResourcePolicy
      )(request.buildAwsValue())
        .map(zio.aws.secretsmanager.model.GetResourcePolicyResponse.wrap)
        .provideEnvironment(r)
    def updateSecret(
        request: zio.aws.secretsmanager.model.UpdateSecretRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.UpdateSecretResponse.ReadOnly
    ] = asyncRequestResponse[UpdateSecretRequest, UpdateSecretResponse](
      "updateSecret",
      api.updateSecret
    )(request.buildAwsValue())
      .map(zio.aws.secretsmanager.model.UpdateSecretResponse.wrap)
      .provideEnvironment(r)
    def removeRegionsFromReplication(
        request: zio.aws.secretsmanager.model.RemoveRegionsFromReplicationRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      RemoveRegionsFromReplicationRequest,
      RemoveRegionsFromReplicationResponse
    ]("removeRegionsFromReplication", api.removeRegionsFromReplication)(
      request.buildAwsValue()
    ).map(
      zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse.wrap
    ).provideEnvironment(r)
    def listSecretVersionIds(
        request: zio.aws.secretsmanager.model.ListSecretVersionIdsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly,
      zio.aws.secretsmanager.model.SecretVersionsListEntry.ReadOnly
    ]] = asyncPaginatedRequest[
      ListSecretVersionIdsRequest,
      ListSecretVersionIdsResponse,
      SecretVersionsListEntry
    ](
      "listSecretVersionIds",
      api.listSecretVersionIds,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.versions().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.secretsmanager.model.SecretVersionsListEntry.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listSecretVersionIdsPaginated(
        request: zio.aws.secretsmanager.model.ListSecretVersionIdsRequest
    ): IO[
      AwsError,
      zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSecretVersionIdsRequest,
      ListSecretVersionIdsResponse
    ]("listSecretVersionIds", api.listSecretVersionIds)(request.buildAwsValue())
      .map(zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.wrap)
      .provideEnvironment(r)
  }
  def rotateSecret(
      request: zio.aws.secretsmanager.model.RotateSecretRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.RotateSecretResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rotateSecret(request))
  def replicateSecretToRegions(
      request: zio.aws.secretsmanager.model.ReplicateSecretToRegionsRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.ReplicateSecretToRegionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.replicateSecretToRegions(request))
  def stopReplicationToReplica(
      request: zio.aws.secretsmanager.model.StopReplicationToReplicaRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.StopReplicationToReplicaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopReplicationToReplica(request))
  def deleteSecret(
      request: zio.aws.secretsmanager.model.DeleteSecretRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.DeleteSecretResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSecret(request))
  def putSecretValue(
      request: zio.aws.secretsmanager.model.PutSecretValueRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.PutSecretValueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putSecretValue(request))
  def getSecretValue(
      request: zio.aws.secretsmanager.model.GetSecretValueRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.GetSecretValueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSecretValue(request))
  def createSecret(
      request: zio.aws.secretsmanager.model.CreateSecretRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.CreateSecretResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSecret(request))
  def describeSecret(
      request: zio.aws.secretsmanager.model.DescribeSecretRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.DescribeSecretResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSecret(request))
  def putResourcePolicy(
      request: zio.aws.secretsmanager.model.PutResourcePolicyRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.PutResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourcePolicy(request))
  def cancelRotateSecret(
      request: zio.aws.secretsmanager.model.CancelRotateSecretRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.CancelRotateSecretResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelRotateSecret(request))
  def getRandomPassword(
      request: zio.aws.secretsmanager.model.GetRandomPasswordRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.GetRandomPasswordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRandomPassword(request))
  def listSecrets(
      request: zio.aws.secretsmanager.model.ListSecretsRequest
  ): ZStream[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.SecretListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listSecrets(request))
  def listSecretsPaginated(
      request: zio.aws.secretsmanager.model.ListSecretsRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.ListSecretsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecretsPaginated(request))
  def untagResource(
      request: zio.aws.secretsmanager.model.UntagResourceRequest
  ): ZIO[zio.aws.secretsmanager.SecretsManager, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def validateResourcePolicy(
      request: zio.aws.secretsmanager.model.ValidateResourcePolicyRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.ValidateResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.validateResourcePolicy(request))
  def updateSecretVersionStage(
      request: zio.aws.secretsmanager.model.UpdateSecretVersionStageRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.UpdateSecretVersionStageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSecretVersionStage(request))
  def deleteResourcePolicy(
      request: zio.aws.secretsmanager.model.DeleteResourcePolicyRequest
  ): ZIO[zio.aws.secretsmanager.SecretsManager, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteResourcePolicy(request))
  def tagResource(
      request: zio.aws.secretsmanager.model.TagResourceRequest
  ): ZIO[zio.aws.secretsmanager.SecretsManager, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def restoreSecret(
      request: zio.aws.secretsmanager.model.RestoreSecretRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.RestoreSecretResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreSecret(request))
  def getResourcePolicy(
      request: zio.aws.secretsmanager.model.GetResourcePolicyRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.GetResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourcePolicy(request))
  def updateSecret(
      request: zio.aws.secretsmanager.model.UpdateSecretRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.UpdateSecretResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSecret(request))
  def removeRegionsFromReplication(
      request: zio.aws.secretsmanager.model.RemoveRegionsFromReplicationRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeRegionsFromReplication(request))
  def listSecretVersionIds(
      request: zio.aws.secretsmanager.model.ListSecretVersionIdsRequest
  ): ZIO[zio.aws.secretsmanager.SecretsManager, AwsError, StreamingOutputResult[
    Any,
    zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly,
    zio.aws.secretsmanager.model.SecretVersionsListEntry.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listSecretVersionIds(request))
  def listSecretVersionIdsPaginated(
      request: zio.aws.secretsmanager.model.ListSecretVersionIdsRequest
  ): ZIO[
    zio.aws.secretsmanager.SecretsManager,
    AwsError,
    zio.aws.secretsmanager.model.ListSecretVersionIdsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecretVersionIdsPaginated(request))
}
