package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  SecretVersionIdType,
  SecretNameType,
  SecretARNType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSecretResponse(
    arn: Option[SecretARNType] = None,
    name: Option[SecretNameType] = None,
    versionId: Option[SecretVersionIdType] = None,
    replicationStatus: Option[
      Iterable[zio.aws.secretsmanager.model.ReplicationStatusType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse = {
    import CreateSecretResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        versionId.map(value =>
          SecretVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .optionallyWith(
        replicationStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationStatus)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.CreateSecretResponse.ReadOnly =
    zio.aws.secretsmanager.model.CreateSecretResponse.wrap(buildAwsValue())
}
object CreateSecretResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.CreateSecretResponse =
      zio.aws.secretsmanager.model.CreateSecretResponse(
        arn.map(value => value),
        name.map(value => value),
        versionId.map(value => value),
        replicationStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Option[SecretARNType]
    def name: Option[SecretNameType]
    def versionId: Option[SecretVersionIdType]
    def replicationStatus: Option[
      List[zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly]
    ]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
    def getVersionId: ZIO[Any, AwsError, SecretVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getReplicationStatus: ZIO[Any, AwsError, List[
      zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly
    ]] = AwsError.unwrapOptionField("replicationStatus", replicationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse
  ) extends zio.aws.secretsmanager.model.CreateSecretResponse.ReadOnly {
    override val arn: Option[SecretARNType] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Option[SecretNameType] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
    override val versionId: Option[SecretVersionIdType] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretVersionIdType(value)
      )
    override val replicationStatus: Option[
      List[zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly]
    ] = scala
      .Option(impl.replicationStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.ReplicationStatusType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse
  ): zio.aws.secretsmanager.model.CreateSecretResponse.ReadOnly = new Wrapper(
    impl
  )
}
