package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  LastAccessedDateType,
  StatusMessageType,
  KmsKeyIdType,
  RegionType
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ReplicationStatusType(
    region: Option[RegionType] = None,
    kmsKeyId: Option[KmsKeyIdType] = None,
    status: Option[zio.aws.secretsmanager.model.StatusType] = None,
    statusMessage: Option[StatusMessageType] = None,
    lastAccessedDate: Option[LastAccessedDateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType = {
    import ReplicationStatusType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType
      .builder()
      .optionallyWith(
        region.map(value => RegionType.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyIdType.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessageType.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        lastAccessedDate.map(value =>
          LastAccessedDateType.unwrap(value): Instant
        )
      )(_.lastAccessedDate)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly =
    zio.aws.secretsmanager.model.ReplicationStatusType.wrap(buildAwsValue())
}
object ReplicationStatusType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.ReplicationStatusType =
      zio.aws.secretsmanager.model.ReplicationStatusType(
        region.map(value => value),
        kmsKeyId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        lastAccessedDate.map(value => value)
      )
    def region: Option[RegionType]
    def kmsKeyId: Option[KmsKeyIdType]
    def status: Option[zio.aws.secretsmanager.model.StatusType]
    def statusMessage: Option[StatusMessageType]
    def lastAccessedDate: Option[LastAccessedDateType]
    def getRegion: ZIO[Any, AwsError, RegionType] =
      AwsError.unwrapOptionField("region", region)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyIdType] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getStatus: ZIO[Any, AwsError, zio.aws.secretsmanager.model.StatusType] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessageType] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getLastAccessedDate: ZIO[Any, AwsError, LastAccessedDateType] =
      AwsError.unwrapOptionField("lastAccessedDate", lastAccessedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType
  ) extends zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly {
    override val region: Option[RegionType] = scala
      .Option(impl.region())
      .map(value => zio.aws.secretsmanager.model.primitives.RegionType(value))
    override val kmsKeyId: Option[KmsKeyIdType] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.secretsmanager.model.primitives.KmsKeyIdType(value))
    override val status: Option[zio.aws.secretsmanager.model.StatusType] = scala
      .Option(impl.status())
      .map(value => zio.aws.secretsmanager.model.StatusType.wrap(value))
    override val statusMessage: Option[StatusMessageType] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.StatusMessageType(value)
      )
    override val lastAccessedDate: Option[LastAccessedDateType] = scala
      .Option(impl.lastAccessedDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.LastAccessedDateType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ReplicationStatusType
  ): zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly = new Wrapper(
    impl
  )
}
