package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.SecretARNType
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RemoveRegionsFromReplicationResponse(
    arn: Option[SecretARNType] = None,
    replicationStatus: Option[
      Iterable[zio.aws.secretsmanager.model.ReplicationStatusType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationResponse = {
    import RemoveRegionsFromReplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        replicationStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.replicationStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse.ReadOnly =
    zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse
      .wrap(buildAwsValue())
}
object RemoveRegionsFromReplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse =
      zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse(
        arn.map(value => value),
        replicationStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Option[SecretARNType]
    def replicationStatus: Option[
      List[zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly]
    ]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getReplicationStatus: ZIO[Any, AwsError, List[
      zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly
    ]] = AwsError.unwrapOptionField("replicationStatus", replicationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationResponse
  ) extends zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse.ReadOnly {
    override val arn: Option[SecretARNType] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val replicationStatus: Option[
      List[zio.aws.secretsmanager.model.ReplicationStatusType.ReadOnly]
    ] = scala
      .Option(impl.replicationStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.ReplicationStatusType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.RemoveRegionsFromReplicationResponse
  ): zio.aws.secretsmanager.model.RemoveRegionsFromReplicationResponse.ReadOnly =
    new Wrapper(impl)
}
