package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  ExcludeLowercaseType,
  RequireEachIncludedTypeType,
  PasswordLengthType,
  ExcludeCharactersType,
  ExcludeUppercaseType,
  IncludeSpaceType,
  ExcludeNumbersType,
  ExcludePunctuationType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRandomPasswordRequest(
    passwordLength: Option[PasswordLengthType] = None,
    excludeCharacters: Option[ExcludeCharactersType] = None,
    excludeNumbers: Option[ExcludeNumbersType] = None,
    excludePunctuation: Option[ExcludePunctuationType] = None,
    excludeUppercase: Option[ExcludeUppercaseType] = None,
    excludeLowercase: Option[ExcludeLowercaseType] = None,
    includeSpace: Option[IncludeSpaceType] = None,
    requireEachIncludedType: Option[RequireEachIncludedTypeType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordRequest = {
    import GetRandomPasswordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordRequest
      .builder()
      .optionallyWith(
        passwordLength.map(value =>
          PasswordLengthType.unwrap(value): java.lang.Long
        )
      )(_.passwordLength)
      .optionallyWith(
        excludeCharacters.map(value =>
          ExcludeCharactersType.unwrap(value): java.lang.String
        )
      )(_.excludeCharacters)
      .optionallyWith(
        excludeNumbers.map(value =>
          ExcludeNumbersType.unwrap(value): java.lang.Boolean
        )
      )(_.excludeNumbers)
      .optionallyWith(
        excludePunctuation.map(value =>
          ExcludePunctuationType.unwrap(value): java.lang.Boolean
        )
      )(_.excludePunctuation)
      .optionallyWith(
        excludeUppercase.map(value =>
          ExcludeUppercaseType.unwrap(value): java.lang.Boolean
        )
      )(_.excludeUppercase)
      .optionallyWith(
        excludeLowercase.map(value =>
          ExcludeLowercaseType.unwrap(value): java.lang.Boolean
        )
      )(_.excludeLowercase)
      .optionallyWith(
        includeSpace.map(value =>
          IncludeSpaceType.unwrap(value): java.lang.Boolean
        )
      )(_.includeSpace)
      .optionallyWith(
        requireEachIncludedType.map(value =>
          RequireEachIncludedTypeType.unwrap(value): java.lang.Boolean
        )
      )(_.requireEachIncludedType)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.GetRandomPasswordRequest.ReadOnly =
    zio.aws.secretsmanager.model.GetRandomPasswordRequest.wrap(buildAwsValue())
}
object GetRandomPasswordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.GetRandomPasswordRequest =
      zio.aws.secretsmanager.model.GetRandomPasswordRequest(
        passwordLength.map(value => value),
        excludeCharacters.map(value => value),
        excludeNumbers.map(value => value),
        excludePunctuation.map(value => value),
        excludeUppercase.map(value => value),
        excludeLowercase.map(value => value),
        includeSpace.map(value => value),
        requireEachIncludedType.map(value => value)
      )
    def passwordLength: Option[PasswordLengthType]
    def excludeCharacters: Option[ExcludeCharactersType]
    def excludeNumbers: Option[ExcludeNumbersType]
    def excludePunctuation: Option[ExcludePunctuationType]
    def excludeUppercase: Option[ExcludeUppercaseType]
    def excludeLowercase: Option[ExcludeLowercaseType]
    def includeSpace: Option[IncludeSpaceType]
    def requireEachIncludedType: Option[RequireEachIncludedTypeType]
    def getPasswordLength: ZIO[Any, AwsError, PasswordLengthType] =
      AwsError.unwrapOptionField("passwordLength", passwordLength)
    def getExcludeCharacters: ZIO[Any, AwsError, ExcludeCharactersType] =
      AwsError.unwrapOptionField("excludeCharacters", excludeCharacters)
    def getExcludeNumbers: ZIO[Any, AwsError, ExcludeNumbersType] =
      AwsError.unwrapOptionField("excludeNumbers", excludeNumbers)
    def getExcludePunctuation: ZIO[Any, AwsError, ExcludePunctuationType] =
      AwsError.unwrapOptionField("excludePunctuation", excludePunctuation)
    def getExcludeUppercase: ZIO[Any, AwsError, ExcludeUppercaseType] =
      AwsError.unwrapOptionField("excludeUppercase", excludeUppercase)
    def getExcludeLowercase: ZIO[Any, AwsError, ExcludeLowercaseType] =
      AwsError.unwrapOptionField("excludeLowercase", excludeLowercase)
    def getIncludeSpace: ZIO[Any, AwsError, IncludeSpaceType] =
      AwsError.unwrapOptionField("includeSpace", includeSpace)
    def getRequireEachIncludedType
        : ZIO[Any, AwsError, RequireEachIncludedTypeType] = AwsError
      .unwrapOptionField("requireEachIncludedType", requireEachIncludedType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordRequest
  ) extends zio.aws.secretsmanager.model.GetRandomPasswordRequest.ReadOnly {
    override val passwordLength: Option[PasswordLengthType] = scala
      .Option(impl.passwordLength())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.PasswordLengthType(value)
      )
    override val excludeCharacters: Option[ExcludeCharactersType] = scala
      .Option(impl.excludeCharacters())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.ExcludeCharactersType(value)
      )
    override val excludeNumbers: Option[ExcludeNumbersType] = scala
      .Option(impl.excludeNumbers())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.ExcludeNumbersType(value)
      )
    override val excludePunctuation: Option[ExcludePunctuationType] = scala
      .Option(impl.excludePunctuation())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.ExcludePunctuationType(value)
      )
    override val excludeUppercase: Option[ExcludeUppercaseType] = scala
      .Option(impl.excludeUppercase())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.ExcludeUppercaseType(value)
      )
    override val excludeLowercase: Option[ExcludeLowercaseType] = scala
      .Option(impl.excludeLowercase())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.ExcludeLowercaseType(value)
      )
    override val includeSpace: Option[IncludeSpaceType] = scala
      .Option(impl.includeSpace())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.IncludeSpaceType(value)
      )
    override val requireEachIncludedType: Option[RequireEachIncludedTypeType] =
      scala
        .Option(impl.requireEachIncludedType())
        .map(value =>
          zio.aws.secretsmanager.model.primitives
            .RequireEachIncludedTypeType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetRandomPasswordRequest
  ): zio.aws.secretsmanager.model.GetRandomPasswordRequest.ReadOnly =
    new Wrapper(impl)
}
