package zio.aws.secretsmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  BooleanType,
  NextTokenType,
  MaxResultsType,
  SecretIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSecretVersionIdsRequest(
    secretId: SecretIdType,
    maxResults: Option[MaxResultsType] = None,
    nextToken: Option[NextTokenType] = None,
    includeDeprecated: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest = {
    import ListSecretVersionIdsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResultsType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextTokenType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        includeDeprecated.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.includeDeprecated)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.ListSecretVersionIdsRequest.ReadOnly =
    zio.aws.secretsmanager.model.ListSecretVersionIdsRequest
      .wrap(buildAwsValue())
}
object ListSecretVersionIdsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.ListSecretVersionIdsRequest =
      zio.aws.secretsmanager.model.ListSecretVersionIdsRequest(
        secretId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        includeDeprecated.map(value => value)
      )
    def secretId: SecretIdType
    def maxResults: Option[MaxResultsType]
    def nextToken: Option[NextTokenType]
    def includeDeprecated: Option[BooleanType]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIncludeDeprecated: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("includeDeprecated", includeDeprecated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest
  ) extends zio.aws.secretsmanager.model.ListSecretVersionIdsRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val maxResults: Option[MaxResultsType] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.MaxResultsType(value)
      )
    override val nextToken: Option[NextTokenType] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.NextTokenType(value)
      )
    override val includeDeprecated: Option[BooleanType] = scala
      .Option(impl.includeDeprecated())
      .map(value => zio.aws.secretsmanager.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ListSecretVersionIdsRequest
  ): zio.aws.secretsmanager.model.ListSecretVersionIdsRequest.ReadOnly =
    new Wrapper(impl)
}
