package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  SecretVersionStageType,
  SecretVersionIdType,
  SecretIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSecretValueRequest(
    secretId: SecretIdType,
    versionId: Option[SecretVersionIdType] = None,
    versionStage: Option[SecretVersionStageType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest = {
    import GetSecretValueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .optionallyWith(
        versionId.map(value =>
          SecretVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .optionallyWith(
        versionStage.map(value =>
          SecretVersionStageType.unwrap(value): java.lang.String
        )
      )(_.versionStage)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.GetSecretValueRequest.ReadOnly =
    zio.aws.secretsmanager.model.GetSecretValueRequest.wrap(buildAwsValue())
}
object GetSecretValueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.GetSecretValueRequest =
      zio.aws.secretsmanager.model.GetSecretValueRequest(
        secretId,
        versionId.map(value => value),
        versionStage.map(value => value)
      )
    def secretId: SecretIdType
    def versionId: Option[SecretVersionIdType]
    def versionStage: Option[SecretVersionStageType]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getVersionId: ZIO[Any, AwsError, SecretVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getVersionStage: ZIO[Any, AwsError, SecretVersionStageType] =
      AwsError.unwrapOptionField("versionStage", versionStage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest
  ) extends zio.aws.secretsmanager.model.GetSecretValueRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val versionId: Option[SecretVersionIdType] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretVersionIdType(value)
      )
    override val versionStage: Option[SecretVersionStageType] = scala
      .Option(impl.versionStage())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretVersionStageType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest
  ): zio.aws.secretsmanager.model.GetSecretValueRequest.ReadOnly = new Wrapper(
    impl
  )
}
