package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.SecretIdType
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    secretId: SecretIdType,
    tags: Iterable[zio.aws.secretsmanager.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.TagResourceRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.TagResourceRequest.ReadOnly =
    zio.aws.secretsmanager.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.TagResourceRequest =
      zio.aws.secretsmanager.model.TagResourceRequest(
        secretId,
        tags.map { item =>
          item.asEditable
        }
      )
    def secretId: SecretIdType
    def tags: List[zio.aws.secretsmanager.model.Tag.ReadOnly]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.secretsmanager.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.TagResourceRequest
  ) extends zio.aws.secretsmanager.model.TagResourceRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val tags: List[zio.aws.secretsmanager.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.secretsmanager.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.TagResourceRequest
  ): zio.aws.secretsmanager.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
