package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  SecretVersionIdType,
  SecretNameType,
  SecretARNType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSecretResponse(
    arn: Option[SecretARNType] = None,
    name: Option[SecretNameType] = None,
    versionId: Option[SecretVersionIdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.UpdateSecretResponse = {
    import UpdateSecretResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.UpdateSecretResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        versionId.map(value =>
          SecretVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.UpdateSecretResponse.ReadOnly =
    zio.aws.secretsmanager.model.UpdateSecretResponse.wrap(buildAwsValue())
}
object UpdateSecretResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.UpdateSecretResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.UpdateSecretResponse =
      zio.aws.secretsmanager.model.UpdateSecretResponse(
        arn.map(value => value),
        name.map(value => value),
        versionId.map(value => value)
      )
    def arn: Option[SecretARNType]
    def name: Option[SecretNameType]
    def versionId: Option[SecretVersionIdType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
    def getVersionId: ZIO[Any, AwsError, SecretVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.UpdateSecretResponse
  ) extends zio.aws.secretsmanager.model.UpdateSecretResponse.ReadOnly {
    override val arn: Option[SecretARNType] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Option[SecretNameType] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
    override val versionId: Option[SecretVersionIdType] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretVersionIdType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.UpdateSecretResponse
  ): zio.aws.secretsmanager.model.UpdateSecretResponse.ReadOnly = new Wrapper(
    impl
  )
}
