package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{TagValueType, TagKeyType}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Tag(
    key: Option[TagKeyType] = None,
    value: Option[TagValueType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.Tag
      .builder()
      .optionallyWith(
        key.map(value => TagKeyType.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => TagValueType.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.Tag.ReadOnly =
    zio.aws.secretsmanager.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.Tag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.Tag =
      zio.aws.secretsmanager.model
        .Tag(key.map(value => value), value.map(value => value))
    def key: Option[TagKeyType]
    def value: Option[TagValueType]
    def getKey: ZIO[Any, AwsError, TagKeyType] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, TagValueType] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.Tag
  ) extends zio.aws.secretsmanager.model.Tag.ReadOnly {
    override val key: Option[TagKeyType] = scala
      .Option(impl.key())
      .map(value => zio.aws.secretsmanager.model.primitives.TagKeyType(value))
    override val value: Option[TagValueType] = scala
      .Option(impl.value())
      .map(value => zio.aws.secretsmanager.model.primitives.TagValueType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.Tag
  ): zio.aws.secretsmanager.model.Tag.ReadOnly = new Wrapper(impl)
}
