package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  SecretVersionIdType,
  SecretVersionStageType,
  SecretIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSecretVersionStageRequest(
    secretId: SecretIdType,
    versionStage: SecretVersionStageType,
    removeFromVersionId: Option[SecretVersionIdType] = None,
    moveToVersionId: Option[SecretVersionIdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageRequest = {
    import UpdateSecretVersionStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .versionStage(
        SecretVersionStageType.unwrap(versionStage): java.lang.String
      )
      .optionallyWith(
        removeFromVersionId.map(value =>
          SecretVersionIdType.unwrap(value): java.lang.String
        )
      )(_.removeFromVersionId)
      .optionallyWith(
        moveToVersionId.map(value =>
          SecretVersionIdType.unwrap(value): java.lang.String
        )
      )(_.moveToVersionId)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.UpdateSecretVersionStageRequest.ReadOnly =
    zio.aws.secretsmanager.model.UpdateSecretVersionStageRequest
      .wrap(buildAwsValue())
}
object UpdateSecretVersionStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.secretsmanager.model.UpdateSecretVersionStageRequest =
      zio.aws.secretsmanager.model.UpdateSecretVersionStageRequest(
        secretId,
        versionStage,
        removeFromVersionId.map(value => value),
        moveToVersionId.map(value => value)
      )
    def secretId: SecretIdType
    def versionStage: SecretVersionStageType
    def removeFromVersionId: Option[SecretVersionIdType]
    def moveToVersionId: Option[SecretVersionIdType]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getVersionStage: ZIO[Any, Nothing, SecretVersionStageType] =
      ZIO.succeed(versionStage)
    def getRemoveFromVersionId: ZIO[Any, AwsError, SecretVersionIdType] =
      AwsError.unwrapOptionField("removeFromVersionId", removeFromVersionId)
    def getMoveToVersionId: ZIO[Any, AwsError, SecretVersionIdType] =
      AwsError.unwrapOptionField("moveToVersionId", moveToVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageRequest
  ) extends zio.aws.secretsmanager.model.UpdateSecretVersionStageRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val versionStage: SecretVersionStageType =
      zio.aws.secretsmanager.model.primitives
        .SecretVersionStageType(impl.versionStage())
    override val removeFromVersionId: Option[SecretVersionIdType] = scala
      .Option(impl.removeFromVersionId())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretVersionIdType(value)
      )
    override val moveToVersionId: Option[SecretVersionIdType] = scala
      .Option(impl.moveToVersionId())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretVersionIdType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.UpdateSecretVersionStageRequest
  ): zio.aws.secretsmanager.model.UpdateSecretVersionStageRequest.ReadOnly =
    new Wrapper(impl)
}
