package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.NextTokenType
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSecretsResponse(
    secretList: Option[Iterable[zio.aws.secretsmanager.model.SecretListEntry]] =
      None,
    nextToken: Option[NextTokenType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse = {
    import ListSecretsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse
      .builder()
      .optionallyWith(
        secretList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secretList)
      .optionallyWith(
        nextToken.map(value => NextTokenType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.ListSecretsResponse.ReadOnly =
    zio.aws.secretsmanager.model.ListSecretsResponse.wrap(buildAwsValue())
}
object ListSecretsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.ListSecretsResponse =
      zio.aws.secretsmanager.model.ListSecretsResponse(
        secretList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def secretList
        : Option[List[zio.aws.secretsmanager.model.SecretListEntry.ReadOnly]]
    def nextToken: Option[NextTokenType]
    def getSecretList: ZIO[Any, AwsError, List[
      zio.aws.secretsmanager.model.SecretListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("secretList", secretList)
    def getNextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse
  ) extends zio.aws.secretsmanager.model.ListSecretsResponse.ReadOnly {
    override val secretList
        : Option[List[zio.aws.secretsmanager.model.SecretListEntry.ReadOnly]] =
      scala
        .Option(impl.secretList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.secretsmanager.model.SecretListEntry.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextTokenType] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.NextTokenType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse
  ): zio.aws.secretsmanager.model.ListSecretsResponse.ReadOnly = new Wrapper(
    impl
  )
}
