package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  SecretIdType,
  SecretBinaryType,
  ClientRequestTokenType,
  SecretVersionStageType,
  SecretStringType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutSecretValueRequest(
    secretId: SecretIdType,
    clientRequestToken: Option[ClientRequestTokenType] = None,
    secretBinary: Option[SecretBinaryType] = None,
    secretString: Option[SecretStringType] = None,
    versionStages: Option[Iterable[SecretVersionStageType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest = {
    import PutSecretValueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenType.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        secretBinary.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.secretBinary)
      .optionallyWith(
        secretString.map(value =>
          SecretStringType.unwrap(value): java.lang.String
        )
      )(_.secretString)
      .optionallyWith(
        versionStages.map(value =>
          value.map { item =>
            SecretVersionStageType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versionStages)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.PutSecretValueRequest.ReadOnly =
    zio.aws.secretsmanager.model.PutSecretValueRequest.wrap(buildAwsValue())
}
object PutSecretValueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.PutSecretValueRequest =
      zio.aws.secretsmanager.model.PutSecretValueRequest(
        secretId,
        clientRequestToken.map(value => value),
        secretBinary.map(value => value),
        secretString.map(value => value),
        versionStages.map(value => value)
      )
    def secretId: SecretIdType
    def clientRequestToken: Option[ClientRequestTokenType]
    def secretBinary: Option[SecretBinaryType]
    def secretString: Option[SecretStringType]
    def versionStages: Option[List[SecretVersionStageType]]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenType] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getSecretBinary: ZIO[Any, AwsError, SecretBinaryType] =
      AwsError.unwrapOptionField("secretBinary", secretBinary)
    def getSecretString: ZIO[Any, AwsError, SecretStringType] =
      AwsError.unwrapOptionField("secretString", secretString)
    def getVersionStages: ZIO[Any, AwsError, List[SecretVersionStageType]] =
      AwsError.unwrapOptionField("versionStages", versionStages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest
  ) extends zio.aws.secretsmanager.model.PutSecretValueRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val clientRequestToken: Option[ClientRequestTokenType] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.ClientRequestTokenType(value)
      )
    override val secretBinary: Option[SecretBinaryType] = scala
      .Option(impl.secretBinary())
      .map(value =>
        zio.aws.secretsmanager.model.primitives
          .SecretBinaryType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val secretString: Option[SecretStringType] = scala
      .Option(impl.secretString())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretStringType(value)
      )
    override val versionStages: Option[List[SecretVersionStageType]] = scala
      .Option(impl.versionStages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.primitives.SecretVersionStageType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest
  ): zio.aws.secretsmanager.model.PutSecretValueRequest.ReadOnly = new Wrapper(
    impl
  )
}
