package zio.aws.secretsmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{NextTokenType, MaxResultsType}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSecretsRequest(
    maxResults: Option[MaxResultsType] = None,
    nextToken: Option[NextTokenType] = None,
    filters: Option[Iterable[zio.aws.secretsmanager.model.Filter]] = None,
    sortOrder: Option[zio.aws.secretsmanager.model.SortOrderType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest = {
    import ListSecretsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResultsType.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextTokenType.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.ListSecretsRequest.ReadOnly =
    zio.aws.secretsmanager.model.ListSecretsRequest.wrap(buildAwsValue())
}
object ListSecretsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.ListSecretsRequest =
      zio.aws.secretsmanager.model.ListSecretsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortOrder.map(value => value)
      )
    def maxResults: Option[MaxResultsType]
    def nextToken: Option[NextTokenType]
    def filters: Option[List[zio.aws.secretsmanager.model.Filter.ReadOnly]]
    def sortOrder: Option[zio.aws.secretsmanager.model.SortOrderType]
    def getMaxResults: ZIO[Any, AwsError, MaxResultsType] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.secretsmanager.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.secretsmanager.model.SortOrderType] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest
  ) extends zio.aws.secretsmanager.model.ListSecretsRequest.ReadOnly {
    override val maxResults: Option[MaxResultsType] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.MaxResultsType(value)
      )
    override val nextToken: Option[NextTokenType] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.NextTokenType(value)
      )
    override val filters
        : Option[List[zio.aws.secretsmanager.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.Filter.wrap(item)
        }.toList
      )
    override val sortOrder: Option[zio.aws.secretsmanager.model.SortOrderType] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.secretsmanager.model.SortOrderType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest
  ): zio.aws.secretsmanager.model.ListSecretsRequest.ReadOnly = new Wrapper(
    impl
  )
}
