package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  NameType,
  BooleanType,
  SecretBinaryType,
  ClientRequestTokenType,
  KmsKeyIdType,
  DescriptionType,
  SecretStringType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSecretRequest(
    name: NameType,
    clientRequestToken: Option[ClientRequestTokenType] = None,
    description: Option[DescriptionType] = None,
    kmsKeyId: Option[KmsKeyIdType] = None,
    secretBinary: Option[SecretBinaryType] = None,
    secretString: Option[SecretStringType] = None,
    tags: Option[Iterable[zio.aws.secretsmanager.model.Tag]] = None,
    addReplicaRegions: Option[
      Iterable[zio.aws.secretsmanager.model.ReplicaRegionType]
    ] = None,
    forceOverwriteReplicaSecret: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest = {
    import CreateSecretRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest
      .builder()
      .name(NameType.unwrap(name): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenType.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyIdType.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        secretBinary.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.secretBinary)
      .optionallyWith(
        secretString.map(value =>
          SecretStringType.unwrap(value): java.lang.String
        )
      )(_.secretString)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        addReplicaRegions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addReplicaRegions)
      .optionallyWith(
        forceOverwriteReplicaSecret.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.forceOverwriteReplicaSecret)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.CreateSecretRequest.ReadOnly =
    zio.aws.secretsmanager.model.CreateSecretRequest.wrap(buildAwsValue())
}
object CreateSecretRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.CreateSecretRequest =
      zio.aws.secretsmanager.model.CreateSecretRequest(
        name,
        clientRequestToken.map(value => value),
        description.map(value => value),
        kmsKeyId.map(value => value),
        secretBinary.map(value => value),
        secretString.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addReplicaRegions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        forceOverwriteReplicaSecret.map(value => value)
      )
    def name: NameType
    def clientRequestToken: Option[ClientRequestTokenType]
    def description: Option[DescriptionType]
    def kmsKeyId: Option[KmsKeyIdType]
    def secretBinary: Option[SecretBinaryType]
    def secretString: Option[SecretStringType]
    def tags: Option[List[zio.aws.secretsmanager.model.Tag.ReadOnly]]
    def addReplicaRegions
        : Option[List[zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly]]
    def forceOverwriteReplicaSecret: Option[BooleanType]
    def getName: ZIO[Any, Nothing, NameType] = ZIO.succeed(name)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenType] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyIdType] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSecretBinary: ZIO[Any, AwsError, SecretBinaryType] =
      AwsError.unwrapOptionField("secretBinary", secretBinary)
    def getSecretString: ZIO[Any, AwsError, SecretStringType] =
      AwsError.unwrapOptionField("secretString", secretString)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.secretsmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAddReplicaRegions: ZIO[Any, AwsError, List[
      zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly
    ]] = AwsError.unwrapOptionField("addReplicaRegions", addReplicaRegions)
    def getForceOverwriteReplicaSecret: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField(
        "forceOverwriteReplicaSecret",
        forceOverwriteReplicaSecret
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest
  ) extends zio.aws.secretsmanager.model.CreateSecretRequest.ReadOnly {
    override val name: NameType =
      zio.aws.secretsmanager.model.primitives.NameType(impl.name())
    override val clientRequestToken: Option[ClientRequestTokenType] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.ClientRequestTokenType(value)
      )
    override val description: Option[DescriptionType] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.DescriptionType(value)
      )
    override val kmsKeyId: Option[KmsKeyIdType] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.secretsmanager.model.primitives.KmsKeyIdType(value))
    override val secretBinary: Option[SecretBinaryType] = scala
      .Option(impl.secretBinary())
      .map(value =>
        zio.aws.secretsmanager.model.primitives
          .SecretBinaryType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val secretString: Option[SecretStringType] = scala
      .Option(impl.secretString())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretStringType(value)
      )
    override val tags: Option[List[zio.aws.secretsmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.secretsmanager.model.Tag.wrap(item)
          }.toList
        )
    override val addReplicaRegions: Option[
      List[zio.aws.secretsmanager.model.ReplicaRegionType.ReadOnly]
    ] = scala
      .Option(impl.addReplicaRegions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.ReplicaRegionType.wrap(item)
        }.toList
      )
    override val forceOverwriteReplicaSecret: Option[BooleanType] = scala
      .Option(impl.forceOverwriteReplicaSecret())
      .map(value => zio.aws.secretsmanager.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest
  ): zio.aws.secretsmanager.model.CreateSecretRequest.ReadOnly = new Wrapper(
    impl
  )
}
