package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  OwningServiceType,
  SecretARNType,
  LastAccessedDateType,
  SecretVersionIdType,
  RegionType,
  RotationEnabledType,
  LastRotatedDateType,
  SecretNameType,
  TimestampType,
  KmsKeyIdType,
  DeletedDateType,
  SecretVersionStageType,
  RotationLambdaARNType,
  DescriptionType,
  LastChangedDateType
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SecretListEntry(
    arn: Option[SecretARNType] = None,
    name: Option[SecretNameType] = None,
    description: Option[DescriptionType] = None,
    kmsKeyId: Option[KmsKeyIdType] = None,
    rotationEnabled: Option[RotationEnabledType] = None,
    rotationLambdaARN: Option[RotationLambdaARNType] = None,
    rotationRules: Option[zio.aws.secretsmanager.model.RotationRulesType] =
      None,
    lastRotatedDate: Option[LastRotatedDateType] = None,
    lastChangedDate: Option[LastChangedDateType] = None,
    lastAccessedDate: Option[LastAccessedDateType] = None,
    deletedDate: Option[DeletedDateType] = None,
    tags: Option[Iterable[zio.aws.secretsmanager.model.Tag]] = None,
    secretVersionsToStages: Option[
      Map[SecretVersionIdType, Iterable[SecretVersionStageType]]
    ] = None,
    owningService: Option[OwningServiceType] = None,
    createdDate: Option[TimestampType] = None,
    primaryRegion: Option[RegionType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.SecretListEntry = {
    import SecretListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.SecretListEntry
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => SecretNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyIdType.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        rotationEnabled.map(value =>
          RotationEnabledType.unwrap(value): java.lang.Boolean
        )
      )(_.rotationEnabled)
      .optionallyWith(
        rotationLambdaARN.map(value =>
          RotationLambdaARNType.unwrap(value): java.lang.String
        )
      )(_.rotationLambdaARN)
      .optionallyWith(rotationRules.map(value => value.buildAwsValue()))(
        _.rotationRules
      )
      .optionallyWith(
        lastRotatedDate.map(value => LastRotatedDateType.unwrap(value): Instant)
      )(_.lastRotatedDate)
      .optionallyWith(
        lastChangedDate.map(value => LastChangedDateType.unwrap(value): Instant)
      )(_.lastChangedDate)
      .optionallyWith(
        lastAccessedDate.map(value =>
          LastAccessedDateType.unwrap(value): Instant
        )
      )(_.lastAccessedDate)
      .optionallyWith(
        deletedDate.map(value => DeletedDateType.unwrap(value): Instant)
      )(_.deletedDate)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        secretVersionsToStages.map(value =>
          value
            .map({ case (key, value) =>
              (SecretVersionIdType.unwrap(key): java.lang.String) -> value.map {
                item =>
                  SecretVersionStageType.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.secretVersionsToStages)
      .optionallyWith(
        owningService.map(value =>
          OwningServiceType.unwrap(value): java.lang.String
        )
      )(_.owningService)
      .optionallyWith(
        createdDate.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        primaryRegion.map(value => RegionType.unwrap(value): java.lang.String)
      )(_.primaryRegion)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.SecretListEntry.ReadOnly =
    zio.aws.secretsmanager.model.SecretListEntry.wrap(buildAwsValue())
}
object SecretListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.SecretListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.SecretListEntry =
      zio.aws.secretsmanager.model.SecretListEntry(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        kmsKeyId.map(value => value),
        rotationEnabled.map(value => value),
        rotationLambdaARN.map(value => value),
        rotationRules.map(value => value.asEditable),
        lastRotatedDate.map(value => value),
        lastChangedDate.map(value => value),
        lastAccessedDate.map(value => value),
        deletedDate.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        secretVersionsToStages.map(value => value),
        owningService.map(value => value),
        createdDate.map(value => value),
        primaryRegion.map(value => value)
      )
    def arn: Option[SecretARNType]
    def name: Option[SecretNameType]
    def description: Option[DescriptionType]
    def kmsKeyId: Option[KmsKeyIdType]
    def rotationEnabled: Option[RotationEnabledType]
    def rotationLambdaARN: Option[RotationLambdaARNType]
    def rotationRules
        : Option[zio.aws.secretsmanager.model.RotationRulesType.ReadOnly]
    def lastRotatedDate: Option[LastRotatedDateType]
    def lastChangedDate: Option[LastChangedDateType]
    def lastAccessedDate: Option[LastAccessedDateType]
    def deletedDate: Option[DeletedDateType]
    def tags: Option[List[zio.aws.secretsmanager.model.Tag.ReadOnly]]
    def secretVersionsToStages
        : Option[Map[SecretVersionIdType, List[SecretVersionStageType]]]
    def owningService: Option[OwningServiceType]
    def createdDate: Option[TimestampType]
    def primaryRegion: Option[RegionType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, SecretNameType] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyIdType] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getRotationEnabled: ZIO[Any, AwsError, RotationEnabledType] =
      AwsError.unwrapOptionField("rotationEnabled", rotationEnabled)
    def getRotationLambdaARN: ZIO[Any, AwsError, RotationLambdaARNType] =
      AwsError.unwrapOptionField("rotationLambdaARN", rotationLambdaARN)
    def getRotationRules: ZIO[
      Any,
      AwsError,
      zio.aws.secretsmanager.model.RotationRulesType.ReadOnly
    ] = AwsError.unwrapOptionField("rotationRules", rotationRules)
    def getLastRotatedDate: ZIO[Any, AwsError, LastRotatedDateType] =
      AwsError.unwrapOptionField("lastRotatedDate", lastRotatedDate)
    def getLastChangedDate: ZIO[Any, AwsError, LastChangedDateType] =
      AwsError.unwrapOptionField("lastChangedDate", lastChangedDate)
    def getLastAccessedDate: ZIO[Any, AwsError, LastAccessedDateType] =
      AwsError.unwrapOptionField("lastAccessedDate", lastAccessedDate)
    def getDeletedDate: ZIO[Any, AwsError, DeletedDateType] =
      AwsError.unwrapOptionField("deletedDate", deletedDate)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.secretsmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSecretVersionsToStages
        : ZIO[Any, AwsError, Map[SecretVersionIdType, List[
          SecretVersionStageType
        ]]] = AwsError.unwrapOptionField(
      "secretVersionsToStages",
      secretVersionsToStages
    )
    def getOwningService: ZIO[Any, AwsError, OwningServiceType] =
      AwsError.unwrapOptionField("owningService", owningService)
    def getCreatedDate: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getPrimaryRegion: ZIO[Any, AwsError, RegionType] =
      AwsError.unwrapOptionField("primaryRegion", primaryRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.SecretListEntry
  ) extends zio.aws.secretsmanager.model.SecretListEntry.ReadOnly {
    override val arn: Option[SecretARNType] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Option[SecretNameType] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretNameType(value)
      )
    override val description: Option[DescriptionType] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.DescriptionType(value)
      )
    override val kmsKeyId: Option[KmsKeyIdType] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.secretsmanager.model.primitives.KmsKeyIdType(value))
    override val rotationEnabled: Option[RotationEnabledType] = scala
      .Option(impl.rotationEnabled())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.RotationEnabledType(value)
      )
    override val rotationLambdaARN: Option[RotationLambdaARNType] = scala
      .Option(impl.rotationLambdaARN())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.RotationLambdaARNType(value)
      )
    override val rotationRules
        : Option[zio.aws.secretsmanager.model.RotationRulesType.ReadOnly] =
      scala
        .Option(impl.rotationRules())
        .map(value =>
          zio.aws.secretsmanager.model.RotationRulesType.wrap(value)
        )
    override val lastRotatedDate: Option[LastRotatedDateType] = scala
      .Option(impl.lastRotatedDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.LastRotatedDateType(value)
      )
    override val lastChangedDate: Option[LastChangedDateType] = scala
      .Option(impl.lastChangedDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.LastChangedDateType(value)
      )
    override val lastAccessedDate: Option[LastAccessedDateType] = scala
      .Option(impl.lastAccessedDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.LastAccessedDateType(value)
      )
    override val deletedDate: Option[DeletedDateType] = scala
      .Option(impl.deletedDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.DeletedDateType(value)
      )
    override val tags: Option[List[zio.aws.secretsmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.secretsmanager.model.Tag.wrap(item)
          }.toList
        )
    override val secretVersionsToStages
        : Option[Map[SecretVersionIdType, List[SecretVersionStageType]]] = scala
      .Option(impl.secretVersionsToStages())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.secretsmanager.model.primitives
              .SecretVersionIdType(key) -> value.asScala.map { item =>
              zio.aws.secretsmanager.model.primitives
                .SecretVersionStageType(item)
            }.toList
          })
          .toMap
      )
    override val owningService: Option[OwningServiceType] = scala
      .Option(impl.owningService())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.OwningServiceType(value)
      )
    override val createdDate: Option[TimestampType] = scala
      .Option(impl.createdDate())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.TimestampType(value)
      )
    override val primaryRegion: Option[RegionType] = scala
      .Option(impl.primaryRegion())
      .map(value => zio.aws.secretsmanager.model.primitives.RegionType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.SecretListEntry
  ): zio.aws.secretsmanager.model.SecretListEntry.ReadOnly = new Wrapper(impl)
}
