package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  RotationLambdaARNType,
  ClientRequestTokenType,
  SecretIdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RotateSecretRequest(
    secretId: SecretIdType,
    clientRequestToken: Option[ClientRequestTokenType] = None,
    rotationLambdaARN: Option[RotationLambdaARNType] = None,
    rotationRules: Option[zio.aws.secretsmanager.model.RotationRulesType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest = {
    import RotateSecretRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenType.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        rotationLambdaARN.map(value =>
          RotationLambdaARNType.unwrap(value): java.lang.String
        )
      )(_.rotationLambdaARN)
      .optionallyWith(rotationRules.map(value => value.buildAwsValue()))(
        _.rotationRules
      )
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.RotateSecretRequest.ReadOnly =
    zio.aws.secretsmanager.model.RotateSecretRequest.wrap(buildAwsValue())
}
object RotateSecretRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.RotateSecretRequest =
      zio.aws.secretsmanager.model.RotateSecretRequest(
        secretId,
        clientRequestToken.map(value => value),
        rotationLambdaARN.map(value => value),
        rotationRules.map(value => value.asEditable)
      )
    def secretId: SecretIdType
    def clientRequestToken: Option[ClientRequestTokenType]
    def rotationLambdaARN: Option[RotationLambdaARNType]
    def rotationRules
        : Option[zio.aws.secretsmanager.model.RotationRulesType.ReadOnly]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenType] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getRotationLambdaARN: ZIO[Any, AwsError, RotationLambdaARNType] =
      AwsError.unwrapOptionField("rotationLambdaARN", rotationLambdaARN)
    def getRotationRules: ZIO[
      Any,
      AwsError,
      zio.aws.secretsmanager.model.RotationRulesType.ReadOnly
    ] = AwsError.unwrapOptionField("rotationRules", rotationRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest
  ) extends zio.aws.secretsmanager.model.RotateSecretRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val clientRequestToken: Option[ClientRequestTokenType] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.ClientRequestTokenType(value)
      )
    override val rotationLambdaARN: Option[RotationLambdaARNType] = scala
      .Option(impl.rotationLambdaARN())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.RotationLambdaARNType(value)
      )
    override val rotationRules
        : Option[zio.aws.secretsmanager.model.RotationRulesType.ReadOnly] =
      scala
        .Option(impl.rotationRules())
        .map(value =>
          zio.aws.secretsmanager.model.RotationRulesType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest
  ): zio.aws.secretsmanager.model.RotateSecretRequest.ReadOnly = new Wrapper(
    impl
  )
}
