package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.AutomaticallyRotateAfterDaysType
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RotationRulesType(
    automaticallyAfterDays: Option[AutomaticallyRotateAfterDaysType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.RotationRulesType = {
    import RotationRulesType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.RotationRulesType
      .builder()
      .optionallyWith(
        automaticallyAfterDays.map(value =>
          AutomaticallyRotateAfterDaysType.unwrap(value): java.lang.Long
        )
      )(_.automaticallyAfterDays)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.RotationRulesType.ReadOnly =
    zio.aws.secretsmanager.model.RotationRulesType.wrap(buildAwsValue())
}
object RotationRulesType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.RotationRulesType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.RotationRulesType =
      zio.aws.secretsmanager.model
        .RotationRulesType(automaticallyAfterDays.map(value => value))
    def automaticallyAfterDays: Option[AutomaticallyRotateAfterDaysType]
    def getAutomaticallyAfterDays
        : ZIO[Any, AwsError, AutomaticallyRotateAfterDaysType] = AwsError
      .unwrapOptionField("automaticallyAfterDays", automaticallyAfterDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.RotationRulesType
  ) extends zio.aws.secretsmanager.model.RotationRulesType.ReadOnly {
    override val automaticallyAfterDays
        : Option[AutomaticallyRotateAfterDaysType] = scala
      .Option(impl.automaticallyAfterDays())
      .map(value =>
        zio.aws.secretsmanager.model.primitives
          .AutomaticallyRotateAfterDaysType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.RotationRulesType
  ): zio.aws.secretsmanager.model.RotationRulesType.ReadOnly = new Wrapper(impl)
}
