package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  NonEmptyResourcePolicyType,
  NameType,
  SecretARNType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetResourcePolicyResponse(
    arn: Option[SecretARNType] = None,
    name: Option[NameType] = None,
    resourcePolicy: Option[NonEmptyResourcePolicyType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyResponse = {
    import GetResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyResponse
      .builder()
      .optionallyWith(
        arn.map(value => SecretARNType.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => NameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        resourcePolicy.map(value =>
          NonEmptyResourcePolicyType.unwrap(value): java.lang.String
        )
      )(_.resourcePolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.GetResourcePolicyResponse.ReadOnly =
    zio.aws.secretsmanager.model.GetResourcePolicyResponse.wrap(buildAwsValue())
}
object GetResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.GetResourcePolicyResponse =
      zio.aws.secretsmanager.model.GetResourcePolicyResponse(
        arn.map(value => value),
        name.map(value => value),
        resourcePolicy.map(value => value)
      )
    def arn: Option[SecretARNType]
    def name: Option[NameType]
    def resourcePolicy: Option[NonEmptyResourcePolicyType]
    def getArn: ZIO[Any, AwsError, SecretARNType] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("name", name)
    def getResourcePolicy: ZIO[Any, AwsError, NonEmptyResourcePolicyType] =
      AwsError.unwrapOptionField("resourcePolicy", resourcePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyResponse
  ) extends zio.aws.secretsmanager.model.GetResourcePolicyResponse.ReadOnly {
    override val arn: Option[SecretARNType] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretARNType(value)
      )
    override val name: Option[NameType] = scala
      .Option(impl.name())
      .map(value => zio.aws.secretsmanager.model.primitives.NameType(value))
    override val resourcePolicy: Option[NonEmptyResourcePolicyType] = scala
      .Option(impl.resourcePolicy())
      .map(value =>
        zio.aws.secretsmanager.model.primitives
          .NonEmptyResourcePolicyType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.GetResourcePolicyResponse
  ): zio.aws.secretsmanager.model.GetResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
