package zio.aws.secretsmanager
import zio.aws.secretsmanager.model.primitives.ExcludeLowercaseType.Type
import java.time.Instant
import zio.aws.secretsmanager.model.primitives.{
  SecretVersionIdType,
  RegionType,
  FilterValueStringType,
  TagKeyType,
  KmsKeyIdType,
  SecretVersionStageType
}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AutomaticallyRotateAfterDaysType extends Subtype[Long]
    type AutomaticallyRotateAfterDaysType =
      zio.aws.secretsmanager.model.primitives.AutomaticallyRotateAfterDaysType.Type
    object BooleanType extends Subtype[Boolean]
    type BooleanType = zio.aws.secretsmanager.model.primitives.BooleanType.Type
    object ClientRequestTokenType extends Subtype[String]
    type ClientRequestTokenType =
      zio.aws.secretsmanager.model.primitives.ClientRequestTokenType.Type
    object CreatedDateType extends Subtype[Instant]
    type CreatedDateType =
      zio.aws.secretsmanager.model.primitives.CreatedDateType.Type
    object DeletedDateType extends Subtype[Instant]
    type DeletedDateType =
      zio.aws.secretsmanager.model.primitives.DeletedDateType.Type
    object DeletionDateType extends Subtype[Instant]
    type DeletionDateType =
      zio.aws.secretsmanager.model.primitives.DeletionDateType.Type
    object DescriptionType extends Subtype[String]
    type DescriptionType =
      zio.aws.secretsmanager.model.primitives.DescriptionType.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage =
      zio.aws.secretsmanager.model.primitives.ErrorMessage.Type
    object ExcludeCharactersType extends Subtype[String]
    type ExcludeCharactersType =
      zio.aws.secretsmanager.model.primitives.ExcludeCharactersType.Type
    object ExcludeLowercaseType extends Subtype[Boolean]
    type ExcludeLowercaseType =
      zio.aws.secretsmanager.model.primitives.ExcludeLowercaseType.Type
    object ExcludeNumbersType extends Subtype[Boolean]
    type ExcludeNumbersType =
      zio.aws.secretsmanager.model.primitives.ExcludeNumbersType.Type
    object ExcludePunctuationType extends Subtype[Boolean]
    type ExcludePunctuationType =
      zio.aws.secretsmanager.model.primitives.ExcludePunctuationType.Type
    object ExcludeUppercaseType extends Subtype[Boolean]
    type ExcludeUppercaseType =
      zio.aws.secretsmanager.model.primitives.ExcludeUppercaseType.Type
    object FilterValueStringType extends Subtype[String]
    type FilterValueStringType =
      zio.aws.secretsmanager.model.primitives.FilterValueStringType.Type
    object IncludeSpaceType extends Subtype[Boolean]
    type IncludeSpaceType =
      zio.aws.secretsmanager.model.primitives.IncludeSpaceType.Type
    object KmsKeyIdType extends Subtype[String]
    type KmsKeyIdType =
      zio.aws.secretsmanager.model.primitives.KmsKeyIdType.Type
    object LastAccessedDateType extends Subtype[Instant]
    type LastAccessedDateType =
      zio.aws.secretsmanager.model.primitives.LastAccessedDateType.Type
    object LastChangedDateType extends Subtype[Instant]
    type LastChangedDateType =
      zio.aws.secretsmanager.model.primitives.LastChangedDateType.Type
    object LastRotatedDateType extends Subtype[Instant]
    type LastRotatedDateType =
      zio.aws.secretsmanager.model.primitives.LastRotatedDateType.Type
    object MaxResultsType extends Subtype[Int]
    type MaxResultsType =
      zio.aws.secretsmanager.model.primitives.MaxResultsType.Type
    object NameType extends Subtype[String]
    type NameType = zio.aws.secretsmanager.model.primitives.NameType.Type
    object NextTokenType extends Subtype[String]
    type NextTokenType =
      zio.aws.secretsmanager.model.primitives.NextTokenType.Type
    object NonEmptyResourcePolicyType extends Subtype[String]
    type NonEmptyResourcePolicyType =
      zio.aws.secretsmanager.model.primitives.NonEmptyResourcePolicyType.Type
    object OwningServiceType extends Subtype[String]
    type OwningServiceType =
      zio.aws.secretsmanager.model.primitives.OwningServiceType.Type
    object PasswordLengthType extends Subtype[Long]
    type PasswordLengthType =
      zio.aws.secretsmanager.model.primitives.PasswordLengthType.Type
    object RandomPasswordType extends Subtype[String]
    type RandomPasswordType =
      zio.aws.secretsmanager.model.primitives.RandomPasswordType.Type
    object RecoveryWindowInDaysType extends Subtype[Long]
    type RecoveryWindowInDaysType =
      zio.aws.secretsmanager.model.primitives.RecoveryWindowInDaysType.Type
    object RegionType extends Subtype[String]
    type RegionType = zio.aws.secretsmanager.model.primitives.RegionType.Type
    object RequireEachIncludedTypeType extends Subtype[Boolean]
    type RequireEachIncludedTypeType =
      zio.aws.secretsmanager.model.primitives.RequireEachIncludedTypeType.Type
    object RotationEnabledType extends Subtype[Boolean]
    type RotationEnabledType =
      zio.aws.secretsmanager.model.primitives.RotationEnabledType.Type
    object RotationLambdaARNType extends Subtype[String]
    type RotationLambdaARNType =
      zio.aws.secretsmanager.model.primitives.RotationLambdaARNType.Type
    object SecretARNType extends Subtype[String]
    type SecretARNType =
      zio.aws.secretsmanager.model.primitives.SecretARNType.Type
    object SecretBinaryType extends Subtype[Chunk[Byte]]
    type SecretBinaryType =
      zio.aws.secretsmanager.model.primitives.SecretBinaryType.Type
    object SecretIdType extends Subtype[String]
    type SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType.Type
    object SecretNameType extends Subtype[String]
    type SecretNameType =
      zio.aws.secretsmanager.model.primitives.SecretNameType.Type
    object SecretStringType extends Subtype[String]
    type SecretStringType =
      zio.aws.secretsmanager.model.primitives.SecretStringType.Type
    object SecretVersionIdType extends Subtype[String]
    type SecretVersionIdType =
      zio.aws.secretsmanager.model.primitives.SecretVersionIdType.Type
    object SecretVersionStageType extends Subtype[String]
    type SecretVersionStageType =
      zio.aws.secretsmanager.model.primitives.SecretVersionStageType.Type
    object StatusMessageType extends Subtype[String]
    type StatusMessageType =
      zio.aws.secretsmanager.model.primitives.StatusMessageType.Type
    object TagKeyType extends Subtype[String]
    type TagKeyType = zio.aws.secretsmanager.model.primitives.TagKeyType.Type
    object TagValueType extends Subtype[String]
    type TagValueType =
      zio.aws.secretsmanager.model.primitives.TagValueType.Type
    object TimestampType extends Subtype[Instant]
    type TimestampType =
      zio.aws.secretsmanager.model.primitives.TimestampType.Type
  }
  type AddReplicaRegionListType =
    List[zio.aws.secretsmanager.model.ReplicaRegionType]
  type FilterValuesStringList = List[FilterValueStringType]
  type FiltersListType = List[zio.aws.secretsmanager.model.Filter]
  type KmsKeyIdListType = List[KmsKeyIdType]
  type RemoveReplicaRegionListType = List[RegionType]
  type ReplicationStatusListType =
    List[zio.aws.secretsmanager.model.ReplicationStatusType]
  type SecretListType = List[zio.aws.secretsmanager.model.SecretListEntry]
  type SecretVersionStagesType = List[SecretVersionStageType]
  type SecretVersionsListType =
    List[zio.aws.secretsmanager.model.SecretVersionsListEntry]
  type SecretVersionsToStagesMapType =
    Map[SecretVersionIdType, Iterable[SecretVersionStageType]]
  type TagKeyListType = List[TagKeyType]
  type TagListType = List[zio.aws.secretsmanager.model.Tag]
  type ValidationErrorsType =
    List[zio.aws.secretsmanager.model.ValidationErrorsEntry]
}
