package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.BooleanType
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ValidateResourcePolicyResponse(
    policyValidationPassed: Option[BooleanType] = None,
    validationErrors: Option[
      Iterable[zio.aws.secretsmanager.model.ValidationErrorsEntry]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyResponse = {
    import ValidateResourcePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyResponse
      .builder()
      .optionallyWith(
        policyValidationPassed.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.policyValidationPassed)
      .optionallyWith(
        validationErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.secretsmanager.model.ValidateResourcePolicyResponse.ReadOnly =
    zio.aws.secretsmanager.model.ValidateResourcePolicyResponse
      .wrap(buildAwsValue())
}
object ValidateResourcePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.secretsmanager.model.ValidateResourcePolicyResponse =
      zio.aws.secretsmanager.model.ValidateResourcePolicyResponse(
        policyValidationPassed.map(value => value),
        validationErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policyValidationPassed: Option[BooleanType]
    def validationErrors: Option[
      List[zio.aws.secretsmanager.model.ValidationErrorsEntry.ReadOnly]
    ]
    def getPolicyValidationPassed: ZIO[Any, AwsError, BooleanType] = AwsError
      .unwrapOptionField("policyValidationPassed", policyValidationPassed)
    def getValidationErrors: ZIO[Any, AwsError, List[
      zio.aws.secretsmanager.model.ValidationErrorsEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("validationErrors", validationErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyResponse
  ) extends zio.aws.secretsmanager.model.ValidateResourcePolicyResponse.ReadOnly {
    override val policyValidationPassed: Option[BooleanType] = scala
      .Option(impl.policyValidationPassed())
      .map(value => zio.aws.secretsmanager.model.primitives.BooleanType(value))
    override val validationErrors: Option[
      List[zio.aws.secretsmanager.model.ValidationErrorsEntry.ReadOnly]
    ] = scala
      .Option(impl.validationErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.secretsmanager.model.ValidationErrorsEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.ValidateResourcePolicyResponse
  ): zio.aws.secretsmanager.model.ValidateResourcePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
