package zio.aws.secretsmanager.model
import zio.ZIO
import zio.aws.secretsmanager.model.primitives.{
  SecretIdType,
  SecretBinaryType,
  ClientRequestTokenType,
  KmsKeyIdType,
  DescriptionType,
  SecretStringType
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateSecretRequest(
    secretId: SecretIdType,
    clientRequestToken: Option[ClientRequestTokenType] = None,
    description: Option[DescriptionType] = None,
    kmsKeyId: Option[KmsKeyIdType] = None,
    secretBinary: Option[SecretBinaryType] = None,
    secretString: Option[SecretStringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest = {
    import UpdateSecretRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest
      .builder()
      .secretId(SecretIdType.unwrap(secretId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenType.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        description.map(value =>
          DescriptionType.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyIdType.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        secretBinary.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.secretBinary)
      .optionallyWith(
        secretString.map(value =>
          SecretStringType.unwrap(value): java.lang.String
        )
      )(_.secretString)
      .build()
  }
  def asReadOnly: zio.aws.secretsmanager.model.UpdateSecretRequest.ReadOnly =
    zio.aws.secretsmanager.model.UpdateSecretRequest.wrap(buildAwsValue())
}
object UpdateSecretRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.secretsmanager.model.UpdateSecretRequest =
      zio.aws.secretsmanager.model.UpdateSecretRequest(
        secretId,
        clientRequestToken.map(value => value),
        description.map(value => value),
        kmsKeyId.map(value => value),
        secretBinary.map(value => value),
        secretString.map(value => value)
      )
    def secretId: SecretIdType
    def clientRequestToken: Option[ClientRequestTokenType]
    def description: Option[DescriptionType]
    def kmsKeyId: Option[KmsKeyIdType]
    def secretBinary: Option[SecretBinaryType]
    def secretString: Option[SecretStringType]
    def getSecretId: ZIO[Any, Nothing, SecretIdType] = ZIO.succeed(secretId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenType] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getDescription: ZIO[Any, AwsError, DescriptionType] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyIdType] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSecretBinary: ZIO[Any, AwsError, SecretBinaryType] =
      AwsError.unwrapOptionField("secretBinary", secretBinary)
    def getSecretString: ZIO[Any, AwsError, SecretStringType] =
      AwsError.unwrapOptionField("secretString", secretString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest
  ) extends zio.aws.secretsmanager.model.UpdateSecretRequest.ReadOnly {
    override val secretId: SecretIdType =
      zio.aws.secretsmanager.model.primitives.SecretIdType(impl.secretId())
    override val clientRequestToken: Option[ClientRequestTokenType] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.ClientRequestTokenType(value)
      )
    override val description: Option[DescriptionType] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.DescriptionType(value)
      )
    override val kmsKeyId: Option[KmsKeyIdType] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.secretsmanager.model.primitives.KmsKeyIdType(value))
    override val secretBinary: Option[SecretBinaryType] = scala
      .Option(impl.secretBinary())
      .map(value =>
        zio.aws.secretsmanager.model.primitives
          .SecretBinaryType(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val secretString: Option[SecretStringType] = scala
      .Option(impl.secretString())
      .map(value =>
        zio.aws.secretsmanager.model.primitives.SecretStringType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.secretsmanager.model.UpdateSecretRequest
  ): zio.aws.secretsmanager.model.UpdateSecretRequest.ReadOnly = new Wrapper(
    impl
  )
}
